/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlOperatorTable;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.sql.util.SqlBasicVisitor;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

class AggFinder
extends SqlBasicVisitor<Void> {
    private final SqlOperatorTable opTab;
    private final boolean over;

    AggFinder(SqlOperatorTable opTab, boolean over) {
        this.opTab = opTab;
        this.over = over;
    }

    public SqlNode findAgg(SqlNode node) {
        try {
            node.accept(this);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlNode)e.getNode();
        }
    }

    public SqlNode findAgg(List<SqlNode> nodes) {
        try {
            for (SqlNode node : nodes) {
                node.accept(this);
            }
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlNode)e.getNode();
        }
    }

    @Override
    public Void visit(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator.isAggregator()) {
            throw new Util.FoundOne(call);
        }
        if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType() == SqlFunctionCategory.USER_DEFINED_FUNCTION) {
            ArrayList<SqlOperator> list = Lists.newArrayList();
            this.opTab.lookupOperatorOverloads(((SqlFunction)operator).getSqlIdentifier(), SqlFunctionCategory.USER_DEFINED_FUNCTION, SqlSyntax.FUNCTION, list);
            for (SqlOperator sqlOperator : list) {
                if (!sqlOperator.isAggregator()) continue;
                throw new Util.FoundOne(call);
            }
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                throw new Util.FoundOne(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }
}

