/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.validate.SqlModality;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorTable;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.util.List;

abstract class AbstractNamespace
implements SqlValidatorNamespace {
    protected final SqlValidatorImpl validator;
    private SqlValidatorImpl.Status status = SqlValidatorImpl.Status.UNVALIDATED;
    protected RelDataType rowType;
    protected RelDataType type;
    private boolean forceNullable;
    protected final SqlNode enclosingNode;

    AbstractNamespace(SqlValidatorImpl validator, SqlNode enclosingNode) {
        this.validator = validator;
        this.enclosingNode = enclosingNode;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validate() {
        switch (this.status) {
            case UNVALIDATED: {
                try {
                    this.status = SqlValidatorImpl.Status.IN_PROGRESS;
                    Util.permAssert(this.rowType == null, "Namespace.rowType must be null before validate has been called");
                    RelDataType type = this.validateImpl();
                    Util.permAssert(type != null, "validateImpl() returned null");
                    if (this.forceNullable) {
                        type = this.validator.getTypeFactory().createTypeWithNullability(type, true);
                    }
                    this.setType(type);
                    break;
                }
                finally {
                    this.status = SqlValidatorImpl.Status.VALID;
                }
            }
            case IN_PROGRESS: {
                throw Util.newInternal("todo: Cycle detected during type-checking");
            }
            case VALID: {
                break;
            }
            default: {
                throw Util.unexpected(this.status);
            }
        }
    }

    protected abstract RelDataType validateImpl();

    @Override
    public RelDataType getRowType() {
        if (this.rowType == null) {
            this.validator.validateNamespace(this);
            Util.permAssert(this.rowType != null, "validate must set rowType");
        }
        return this.rowType;
    }

    @Override
    public RelDataType getRowTypeSansSystemColumns() {
        return this.getRowType();
    }

    @Override
    public RelDataType getType() {
        Util.discard(this.getRowType());
        return this.type;
    }

    @Override
    public void setType(RelDataType type) {
        this.type = type;
        this.rowType = this.convertToStruct(type);
    }

    @Override
    public SqlNode getEnclosingNode() {
        return this.enclosingNode;
    }

    @Override
    public SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public SqlValidatorNamespace lookupChild(String name) {
        return this.validator.lookupFieldNamespace(this.getRowType(), name);
    }

    @Override
    public boolean fieldExists(String name) {
        RelDataType rowType = this.getRowType();
        return this.validator.catalogReader.field(rowType, name) != null;
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return ImmutableList.of();
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public void makeNullable() {
        this.forceNullable = true;
    }

    @Override
    public String translate(String name) {
        return name;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        return this;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    protected RelDataType convertToStruct(RelDataType type) {
        RelDataType collectionType;
        RelDataType componentType = type.getComponentType();
        if (componentType == null || componentType.isStruct()) {
            return type;
        }
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        RelDataType structType = typeFactory.builder().add(this.validator.deriveAlias(this.getNode(), 0), componentType).build();
        switch (type.getSqlTypeName()) {
            case ARRAY: {
                collectionType = typeFactory.createArrayType(structType, -1L);
                break;
            }
            case MULTISET: {
                collectionType = typeFactory.createMultisetType(structType, -1L);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
        return typeFactory.createTypeWithNullability(collectionType, type.isNullable());
    }
}

