/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.util;

import hive.com.google.common.collect.HashMultimap;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Multimap;
import hive.org.apache.calcite.sql.SqlBinaryOperator;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlOperatorTable;
import hive.org.apache.calcite.sql.SqlPostfixOperator;
import hive.org.apache.calcite.sql.SqlPrefixOperator;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReflectiveSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";
    private final Multimap<String, SqlOperator> operators = HashMultimap.create();
    private final Map<Pair<String, SqlSyntax>, SqlOperator> mapNameToOp = new HashMap<Pair<String, SqlSyntax>, SqlOperator>();

    protected ReflectiveSqlOperatorTable() {
    }

    public final void init() {
        for (Field field : this.getClass().getFields()) {
            try {
                SqlOperator op;
                if (SqlFunction.class.isAssignableFrom(field.getType())) {
                    op = (SqlFunction)field.get(this);
                    if (op == null) continue;
                    this.register((SqlFunction)op);
                    continue;
                }
                if (!SqlOperator.class.isAssignableFrom(field.getType())) continue;
                op = (SqlOperator)field.get(this);
                this.register(op);
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal(e, "Error while initializing operator table");
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while initializing operator table");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        String simpleName;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName = Util.last(opName.names);
        } else {
            simpleName = opName.getSimple();
        }
        Collection<SqlOperator> list = this.operators.get(simpleName.toUpperCase());
        if (list.isEmpty()) {
            return;
        }
        for (SqlOperator op : list) {
            if (op.getSyntax() == syntax) {
                operatorList.add(op);
                continue;
            }
            if (syntax != SqlSyntax.FUNCTION || !(op instanceof SqlFunction)) continue;
            operatorList.add(op);
        }
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                SqlOperator extra = this.mapNameToOp.get(Pair.of(simpleName, syntax));
                if (extra == null || operatorList.contains(extra)) return;
                operatorList.add(extra);
            }
        }
    }

    public void register(SqlOperator op) {
        this.operators.put(op.getName(), op);
        if (op instanceof SqlBinaryOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.BINARY), op);
        } else if (op instanceof SqlPrefixOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.PREFIX), op);
        } else if (op instanceof SqlPostfixOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.POSTFIX), op);
        }
    }

    public void register(SqlFunction function) {
        this.operators.put(function.getName(), function);
        SqlFunctionCategory funcType = function.getFunctionType();
        assert (funcType != null) : "Function type for " + function.getName() + " not set";
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return ImmutableList.copyOf(this.operators.values());
    }
}

