/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperandCountRange;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.type.SqlOperandCountRanges;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.Pair;
import java.util.List;

public class AssignableOperandTypeChecker
implements SqlOperandTypeChecker {
    private final List<RelDataType> paramTypes;

    public AssignableOperandTypeChecker(List<RelDataType> paramTypes) {
        this.paramTypes = ImmutableList.copyOf(paramTypes);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.paramTypes.size());
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<SqlNode> operands = callBinding.getCall().getOperandList();
        for (Pair<RelDataType, SqlNode> pair : Pair.zip(this.paramTypes, operands)) {
            RelDataType argType = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)pair.right);
            if (SqlTypeUtil.canAssignFrom((RelDataType)pair.left, argType)) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        StringBuilder sb = new StringBuilder();
        sb.append(opName);
        sb.append("(");
        for (Ord paramType : Ord.zip(this.paramTypes)) {
            if (paramType.i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(((RelDataType)paramType.e).getFamily());
            sb.append(">");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

