/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.SqlSpecialOperator;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.Static;
import java.util.List;

public class SqlMultisetValueConstructor
extends SqlSpecialOperator {
    public SqlMultisetValueConstructor() {
        this("MULTISET", SqlKind.MULTISET_VALUE_CONSTRUCTOR);
    }

    protected SqlMultisetValueConstructor(String name, SqlKind kind) {
        super(name, kind, 200, false, ReturnTypes.ARG0, null, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = this.getComponentType(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        if (null == type) {
            return null;
        }
        return SqlTypeUtil.createMultisetType(opBinding.getTypeFactory(), type, false);
    }

    protected RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return typeFactory.leastRestrictive(argTypes);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.getCall().getOperandList());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(Static.RESOURCE.requireAtLeastOneArg());
        }
        RelDataType componentType = this.getComponentType(callBinding.getTypeFactory(), argTypes);
        if (null == componentType) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("[", "]");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }
}

