/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlMapValueConstructor
extends SqlMultisetValueConstructor {
    public SqlMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        Pair<RelDataType, RelDataType> type = this.getComponentTypes(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        if (null == type) {
            return null;
        }
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), (RelDataType)type.left, (RelDataType)type.right, false);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.getCall().getOperandList());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresTwoOrMoreArgs());
        }
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
        }
        Pair<RelDataType, RelDataType> componentType = this.getComponentTypes(callBinding.getTypeFactory(), argTypes);
        if (null == componentType.left || null == componentType.right) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    private Pair<RelDataType, RelDataType> getComponentTypes(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }
}

