/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlSelect;
import hive.org.apache.calcite.sql.SqlSpecialOperator;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;

public class SqlCursorConstructor
extends SqlSpecialOperator {
    public SqlCursorConstructor() {
        super("CURSOR", SqlKind.CURSOR, 200, false, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.ANY);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        validator.declareCursor(subSelect, scope);
        subSelect.validateExpr(validator, scope);
        return super.deriveType(validator, scope, call);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword("CURSOR");
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

