/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import java.util.Calendar;

public class SqlTimeLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeLiteral(Calendar t, int precision, boolean hasTimeZone, SqlParserPos pos) {
        this(t, precision, hasTimeZone, "HH:mm:ss", pos);
    }

    SqlTimeLiteral(Calendar t, int precision, boolean hasTimeZone, String format, SqlParserPos pos) {
        super(t, hasTimeZone, SqlTypeName.TIME, precision, format, pos);
        Preconditions.checkArgument(this.precision >= 0 && this.precision <= 3);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimeLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    @Override
    public String toString() {
        return "TIME '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        String result = this.getTime().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            String digits = Long.toString(cal.getTimeInMillis());
            result = result + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (0 == cal.get(14));
        return result;
    }
}

