/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public enum SqlKind {
    OTHER,
    SELECT,
    JOIN,
    IDENTIFIER,
    LITERAL,
    OTHER_FUNCTION,
    EXPLAIN,
    INSERT,
    DELETE,
    UPDATE,
    SET_OPTION,
    DYNAMIC_PARAM,
    ORDER_BY,
    WITH,
    WITH_ITEM,
    UNION,
    EXCEPT,
    INTERSECT,
    AS,
    OVER,
    FILTER,
    WINDOW,
    MERGE,
    TABLESAMPLE,
    TIMES,
    DIVIDE,
    PLUS,
    MINUS,
    IN,
    LESS_THAN,
    GREATER_THAN,
    LESS_THAN_OR_EQUAL,
    GREATER_THAN_OR_EQUAL,
    EQUALS,
    NOT_EQUALS,
    IS_DISTINCT_FROM,
    IS_NOT_DISTINCT_FROM,
    OR,
    AND,
    DOT,
    OVERLAPS,
    LIKE,
    SIMILAR,
    BETWEEN,
    CASE,
    NOT,
    PLUS_PREFIX,
    MINUS_PREFIX,
    EXISTS,
    VALUES,
    EXPLICIT_TABLE,
    SCALAR_QUERY,
    PROCEDURE_CALL,
    NEW_SPECIFICATION,
    DESCENDING,
    NULLS_FIRST,
    NULLS_LAST,
    IS_TRUE,
    IS_FALSE,
    IS_NOT_TRUE,
    IS_NOT_FALSE,
    IS_UNKNOWN,
    IS_NULL,
    IS_NOT_NULL,
    PRECEDING,
    FOLLOWING,
    FIELD_ACCESS,
    INPUT_REF,
    LOCAL_REF,
    CORREL_VARIABLE,
    ROW,
    COLUMN_LIST,
    CAST,
    NEXT_VALUE,
    CURRENT_VALUE,
    FLOOR,
    CEIL,
    TRIM,
    JDBC_FN,
    MULTISET_VALUE_CONSTRUCTOR,
    MULTISET_QUERY_CONSTRUCTOR,
    UNNEST,
    LATERAL,
    COLLECTION_TABLE,
    ARRAY_VALUE_CONSTRUCTOR,
    ARRAY_QUERY_CONSTRUCTOR,
    MAP_VALUE_CONSTRUCTOR,
    MAP_QUERY_CONSTRUCTOR,
    CURSOR,
    LITERAL_CHAIN,
    ESCAPE,
    REINTERPRET,
    EXTEND,
    CUBE,
    ROLLUP,
    GROUPING_SETS,
    GROUPING,
    GROUPING_ID,
    GROUP_ID;

    public static final EnumSet<SqlKind> SET_QUERY;
    public static final Set<SqlKind> EXPRESSION;
    public static final EnumSet<SqlKind> DML;
    public static final EnumSet<SqlKind> QUERY;
    public static final Set<SqlKind> TOP_LEVEL;
    public static final Set<SqlKind> FUNCTION;
    public static final Set<SqlKind> COMPARISON;

    public SqlKind reverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        return this;
    }

    public final boolean belongsTo(Collection<SqlKind> category) {
        return category.contains((Object)this);
    }

    private static <E extends Enum<E>> EnumSet<E> plus(EnumSet<E> set0, EnumSet<E> set1) {
        Object set = set0.clone();
        ((AbstractCollection)set).addAll(set1);
        return set;
    }

    static {
        SET_QUERY = EnumSet.of(UNION, INTERSECT, EXCEPT);
        EXPRESSION = EnumSet.complementOf(EnumSet.of(AS, new SqlKind[]{DESCENDING, CUBE, ROLLUP, GROUPING_SETS, EXTEND, SELECT, JOIN, OTHER_FUNCTION, CAST, TRIM, FLOOR, CEIL, LITERAL_CHAIN, JDBC_FN, PRECEDING, FOLLOWING, ORDER_BY, NULLS_FIRST, NULLS_LAST, COLLECTION_TABLE, TABLESAMPLE, VALUES, WITH, WITH_ITEM}));
        DML = EnumSet.of(INSERT, DELETE, UPDATE, MERGE, PROCEDURE_CALL);
        QUERY = EnumSet.of(SELECT, new SqlKind[]{UNION, INTERSECT, EXCEPT, VALUES, WITH, ORDER_BY, EXPLICIT_TABLE});
        TOP_LEVEL = SqlKind.plus(QUERY, DML);
        FUNCTION = EnumSet.of(OTHER_FUNCTION, ROW, TRIM, CAST, JDBC_FN);
        COMPARISON = EnumSet.of(IN, new SqlKind[]{EQUALS, NOT_EQUALS, LESS_THAN, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL});
    }
}

