/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlBasicCall;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlOperandTypeInference;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlFunction
extends SqlOperator {
    private final SqlFunctionCategory category;
    private final SqlIdentifier sqlIdentifier;
    private final List<RelDataType> paramTypes;

    public SqlFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, null, category);
        assert (category != SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR || returnTypeInference != null);
    }

    public SqlFunction(SqlIdentifier sqlIdentifier, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory funcType) {
        this(Util.last(sqlIdentifier.names), sqlIdentifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, funcType);
    }

    protected SqlFunction(String name, SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory category) {
        super(name, kind, 100, 100, returnTypeInference, operandTypeInference, operandTypeChecker);
        this.sqlIdentifier = sqlIdentifier;
        this.category = category;
        List<RelDataType> list = this.paramTypes = paramTypes == null ? null : ImmutableList.copyOf(paramTypes);
        assert (category != null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public SqlIdentifier getNameAsId() {
        if (this.sqlIdentifier != null) {
            return this.sqlIdentifier;
        }
        return new SqlIdentifier(this.getName(), SqlParserPos.ZERO);
    }

    public List<RelDataType> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    public SqlFunctionCategory getFunctionType() {
        return this.category;
    }

    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        this.validateQuantifier(validator, call);
    }

    protected void validateQuantifier(SqlValidator validator, SqlCall call) {
        if (null != call.getFunctionQuantifier() && !this.isQuantifierAllowed()) {
            throw validator.newValidationError(call.getFunctionQuantifier(), Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.deriveType(validator, scope, call, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call, boolean convertRowArgToColumnList) {
        List<SqlNode> operands = call.getOperandList();
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        validator.pushFunctionCall();
        try {
            RelDataType relDataType;
            ImmutableList.Builder argTypeBuilder = ImmutableList.builder();
            boolean containsRowArg = false;
            for (SqlNode operand : operands) {
                RelDataType nodeType;
                if (operand.getKind() == SqlKind.ROW && convertRowArgToColumnList) {
                    containsRowArg = true;
                    RelDataTypeFactory typeFactory = validator.getTypeFactory();
                    nodeType = typeFactory.createSqlType(SqlTypeName.COLUMN_LIST);
                } else {
                    nodeType = validator.deriveType(operandScope, operand);
                }
                validator.setValidatedNodeType(operand, nodeType);
                argTypeBuilder.add(nodeType);
            }
            ImmutableCollection argTypes = argTypeBuilder.build();
            SqlFunction function = SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)((Object)argTypes), this.getFunctionType());
            if (containsRowArg) {
                if (function == null && SqlUtil.matchRoutinesByParameterCount(validator.getOperatorTable(), this.getNameAsId(), (List<RelDataType>)((Object)argTypes), this.getFunctionType())) {
                    for (SqlNode operand : operands) {
                        if (operand.getKind() != SqlKind.ROW) continue;
                        validator.removeValidatedNodeType(operand);
                    }
                    relDataType = this.deriveType(validator, scope, call, false);
                    return relDataType;
                }
                if (function != null) {
                    validator.validateColumnListParams(function, (List<RelDataType>)((Object)argTypes), operands);
                }
            }
            if (this.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
                relDataType = validator.deriveConstructorType(scope, call, this, function, (List<RelDataType>)((Object)argTypes));
                return relDataType;
            }
            if (function == null) {
                throw validator.handleUnresolvedFunction(call, this, (List<RelDataType>)((Object)argTypes));
            }
            ((SqlBasicCall)call).setOperator(function);
            relDataType = function.validateOperands(validator, operandScope, call);
            return relDataType;
        }
        finally {
            validator.popFunctionCall();
        }
    }
}

