/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.sql.SqlAbstractStringLiteral;
import hive.org.apache.calcite.sql.SqlCollation;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.util.NlsString;
import java.util.List;

public class SqlCharStringLiteral
extends SqlAbstractStringLiteral {
    private static final Function<SqlLiteral, NlsString> F = new Function<SqlLiteral, NlsString>(){

        @Override
        public NlsString apply(SqlLiteral literal) {
            return ((SqlCharStringLiteral)literal).getNlsString();
        }
    };

    protected SqlCharStringLiteral(NlsString val, SqlParserPos pos) {
        super(val, SqlTypeName.CHAR, pos);
    }

    public NlsString getNlsString() {
        return (NlsString)this.value;
    }

    public SqlCollation getCollation() {
        return this.getNlsString().getCollation();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlCharStringLiteral((NlsString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof NlsString);
        writer.literal(this.value.toString());
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlCharStringLiteral(NlsString.concat(Lists.transform(literals, F)), literals.get(0).getParserPosition());
    }
}

