/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.util.UnmodifiableArrayList;
import java.util.List;

public class SqlBasicCall
extends SqlCall {
    private SqlOperator operator;
    public final SqlNode[] operands;
    private final SqlLiteral functionQuantifier;
    private final boolean expanded;

    public SqlBasicCall(SqlOperator operator, SqlNode[] operands, SqlParserPos pos) {
        this(operator, operands, pos, false, null);
    }

    protected SqlBasicCall(SqlOperator operator, SqlNode[] operands, SqlParserPos pos, boolean expanded, SqlLiteral functionQualifier) {
        super(pos);
        this.operator = operator;
        this.operands = operands;
        this.expanded = expanded;
        this.functionQuantifier = functionQualifier;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        this.operands[i] = operand;
    }

    public void setOperator(SqlOperator operator) {
        this.operator = operator;
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    public SqlNode[] getOperands() {
        return this.operands;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return UnmodifiableArrayList.of(this.operands);
    }

    @Override
    public <S extends SqlNode> S operand(int i) {
        return (S)this.operands[i];
    }

    @Override
    public int operandCount() {
        return this.operands.length;
    }

    @Override
    public SqlLiteral getFunctionQuantifier() {
        return this.functionQuantifier;
    }
}

