/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.logical.LogicalProject;

public class ProjectSortTransposeRule
extends RelOptRule {
    public static final ProjectSortTransposeRule INSTANCE = new ProjectSortTransposeRule();

    private ProjectSortTransposeRule() {
        super(ProjectSortTransposeRule.operand(LogicalProject.class, ProjectSortTransposeRule.operand(Sort.class, ProjectSortTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        Sort sort = (Sort)call.rel(1);
        if (sort.getClass() != Sort.class) {
            return;
        }
        RelNode newProject = project.copy(project.getTraitSet(), ImmutableList.of(sort.getInput()));
        Sort newSort = sort.copy(sort.getTraitSet(), newProject, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(newSort);
    }
}

