/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.base.Predicate;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import hive.org.apache.calcite.interpreter.Bindables;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.schema.FilterableTable;
import hive.org.apache.calcite.schema.ProjectableFilterableTable;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.mapping.Mapping;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public abstract class FilterTableScanRule
extends RelOptRule {
    public static final Predicate<TableScan> PREDICATE = new Predicate<TableScan>(){

        @Override
        public boolean apply(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final FilterTableScanRule INSTANCE = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operand(TableScan.class, null, PREDICATE, FilterTableScanRule.none()), new RelOptRuleOperand[0]), "FilterTableRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, filter, scan);
        }
    };
    public static final FilterTableScanRule INTERPRETER = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operand(EnumerableInterpreter.class, FilterTableScanRule.operand(TableScan.class, null, PREDICATE, FilterTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "FilterTableRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, filter, scan);
        }
    };

    protected FilterTableScanRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList.Builder filters = ImmutableList.builder();
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters.addAll(bindableScan.filters);
            projects = bindableScan.projects;
        } else {
            projects = scan.identity();
        }
        Mapping mapping = Mappings.target(projects, scan.getTable().getRowType().getFieldCount());
        filters.add(RexUtil.apply((Mappings.TargetMapping)mapping, filter.getCondition()));
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), (List<RexNode>)((Object)filters.build()), projects));
    }
}

