/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import hive.org.apache.calcite.rel.metadata.RelColumnMapping;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilterTableFunctionTransposeRule
extends RelOptRule {
    public static final FilterTableFunctionTransposeRule INSTANCE = new FilterTableFunctionTransposeRule();

    private FilterTableFunctionTransposeRule() {
        super(FilterTableFunctionTransposeRule.operand(LogicalFilter.class, FilterTableFunctionTransposeRule.operand(LogicalTableFunctionScan.class, FilterTableFunctionTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalTableFunctionScan funcRel = (LogicalTableFunctionScan)call.rel(1);
        Set<RelColumnMapping> columnMappings = funcRel.getColumnMappings();
        if (columnMappings == null || columnMappings.isEmpty()) {
            return;
        }
        List<RelNode> funcInputs = funcRel.getInputs();
        if (funcInputs.size() != 1) {
            return;
        }
        if (funcRel.getRowType().getFieldCount() != funcInputs.get(0).getRowType().getFieldCount()) {
            return;
        }
        for (RelColumnMapping mapping : columnMappings) {
            if (mapping.iInputColumn != mapping.iOutputColumn) {
                return;
            }
            if (!mapping.derived) continue;
            return;
        }
        ArrayList<RelNode> newFuncInputs = new ArrayList<RelNode>();
        RelOptCluster cluster = funcRel.getCluster();
        RexNode condition = filter.getCondition();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = funcRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        for (RelNode funcInput : funcInputs) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, funcInput.getRowType().getFieldList(), adjustments));
            newFuncInputs.add(LogicalFilter.create(funcInput, newCondition));
        }
        LogicalTableFunctionScan newFuncRel = LogicalTableFunctionScan.create(cluster, newFuncInputs, funcRel.getCall(), funcRel.getElementType(), funcRel.getRowType(), columnMappings);
        call.transformTo(newFuncRel);
    }
}

