/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexProgramBuilder;
import hive.org.apache.calcite.rex.RexUtil;

public class FilterMergeRule
extends RelOptRule {
    public static final FilterMergeRule INSTANCE = new FilterMergeRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public FilterMergeRule(RelFactories.FilterFactory filterFactory) {
        super(FilterMergeRule.operand(Filter.class, FilterMergeRule.operand(Filter.class, FilterMergeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter topFilter = (Filter)call.rel(0);
        Filter bottomFilter = (Filter)call.rel(1);
        RexBuilder rexBuilder = topFilter.getCluster().getRexBuilder();
        RexProgram bottomProgram = this.createProgram(bottomFilter);
        RexProgram topProgram = this.createProgram(topFilter);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        Filter newFilterRel = (Filter)this.filterFactory.createFilter(bottomFilter.getInput(), RexUtil.flatten(rexBuilder, newCondition));
        call.transformTo(newFilterRel);
    }

    private RexProgram createProgram(Filter filterRel) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(filterRel.getRowType(), filterRel.getCluster().getRexBuilder());
        programBuilder.addIdentity();
        programBuilder.addCondition(filterRel.getCondition());
        return programBuilder.getProgram();
    }
}

