/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AggregateProjectMergeRule
extends RelOptRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule();

    private AggregateProjectMergeRule() {
        super(AggregateProjectMergeRule.operand(Aggregate.class, AggregateProjectMergeRule.operand(Project.class, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(Aggregate aggregate, Project project) {
        Aggregate newAggregate;
        ArrayList<Integer> newKeys = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int key : aggregate.getGroupSet()) {
            RexNode rex = project.getProjects().get(key);
            if (rex instanceof RexInputRef) {
                int newKey = ((RexInputRef)rex).getIndex();
                newKeys.add(newKey);
                map.put(key, newKey);
                continue;
            }
            return null;
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.indicator) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            int newFilterArg;
            ImmutableList.Builder newArgs = ImmutableList.builder();
            for (int arg : aggregateCall.getArgList()) {
                RexNode rex = project.getProjects().get(arg);
                if (rex instanceof RexInputRef) {
                    newArgs.add((Object)((RexInputRef)rex).getIndex());
                    continue;
                }
                return null;
            }
            if (aggregateCall.filterArg >= 0) {
                RexNode rex = project.getProjects().get(aggregateCall.filterArg);
                if (!(rex instanceof RexInputRef)) {
                    return null;
                }
                newFilterArg = ((RexInputRef)rex).getIndex();
            } else {
                newFilterArg = -1;
            }
            aggCalls.add(aggregateCall.copy((List<Integer>)((Object)newArgs.build()), newFilterArg));
        }
        RelNode rel = newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()));
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = Lists.newArrayList();
            Iterator i$ = newKeys.iterator();
            while (i$.hasNext()) {
                int newKey = (Integer)i$.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                i$ = newKeys.iterator();
                while (i$.hasNext()) {
                    int newKey = (Integer)i$.next();
                    posList.add(aggregate.getGroupCount() + newGroupSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            rel = RelOptUtil.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, rel, posList);
        }
        return rel;
    }
}

