/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdUtil;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class RelMdDistinctRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.DISTINCT_ROW_COUNT.method, new RelMdDistinctRowCount());

    protected RelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(Union rel, ImmutableBitSet groupKey, RexNode predicate) {
        Double rowCount = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            RexNode modifiedPred;
            Double partialRowCount = RelMetadataQuery.getDistinctRowCount(input, groupKey, modifiedPred = predicate == null ? null : predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments)));
            if (partialRowCount == null) {
                return null;
            }
            rowCount = rowCount + partialRowCount;
        }
        return rowCount;
    }

    public Double getDistinctRowCount(Sort rel, ImmutableBitSet groupKey, RexNode predicate) {
        return RelMetadataQuery.getDistinctRowCount(rel.getInput(), groupKey, predicate);
    }

    public Double getDistinctRowCount(Exchange rel, ImmutableBitSet groupKey, RexNode predicate) {
        return RelMetadataQuery.getDistinctRowCount(rel.getInput(), groupKey, predicate);
    }

    public Double getDistinctRowCount(Filter rel, ImmutableBitSet groupKey, RexNode predicate) {
        RexNode unionPreds = RelMdUtil.unionPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition());
        return RelMetadataQuery.getDistinctRowCount(rel.getInput(), groupKey, unionPreds);
    }

    public Double getDistinctRowCount(Join rel, ImmutableBitSet groupKey, RexNode predicate) {
        return RelMdUtil.getJoinDistinctRowCount(rel, rel.getJoinType(), groupKey, predicate, false);
    }

    public Double getDistinctRowCount(SemiJoin rel, ImmutableBitSet groupKey, RexNode predicate) {
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        if (predicate != null) {
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return RelMetadataQuery.getDistinctRowCount(rel.getLeft(), groupKey, newPred);
    }

    public Double getDistinctRowCount(Aggregate rel, ImmutableBitSet groupKey, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPreds = RexUtil.composeConjunction(rexBuilder, pushable, true);
        ImmutableBitSet.Builder childKey = ImmutableBitSet.builder();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getInput(), childKey.build(), childPreds);
        if (distinctRowCount == null) {
            return null;
        }
        if (notPushable.isEmpty()) {
            return distinctRowCount;
        }
        RexNode preds = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return distinctRowCount * RelMdUtil.guessSelectivity(preds);
    }

    public Double getDistinctRowCount(Values rel, ImmutableBitSet groupKey, RexNode predicate) {
        Double selectivity = RelMdUtil.guessSelectivity(predicate);
        Double nRows = rel.getRows() / 2.0;
        return RelMdUtil.numDistinctVals(nRows, nRows * selectivity);
    }

    public Double getDistinctRowCount(Project rel, ImmutableBitSet groupKey, RexNode predicate) {
        ImmutableBitSet.Builder baseCols = ImmutableBitSet.builder();
        ImmutableBitSet.Builder projCols = ImmutableBitSet.builder();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushPastProject(childPred, rel);
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getInput(), baseCols.build(), modifiedPred);
        if (distinctRowCount == null) {
            return null;
        }
        if (!notPushable.isEmpty()) {
            RexNode preds = RexUtil.composeConjunction(rexBuilder, notPushable, true);
            distinctRowCount = distinctRowCount * RelMdUtil.guessSelectivity(preds);
        }
        if (projCols.cardinality() == 0) {
            return distinctRowCount;
        }
        for (int bit : projCols.build()) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            distinctRowCount = distinctRowCount * subRowCount;
        }
        return RelMdUtil.numDistinctVals(distinctRowCount, RelMetadataQuery.getRowCount(rel));
    }

    public Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(rel, groupKey);
        if (uniq) {
            return NumberUtil.multiply(RelMetadataQuery.getRowCount(rel), RelMetadataQuery.getSelectivity(rel, predicate));
        }
        return null;
    }
}

