/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.collect.ImmutableSet;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.TableFunctionScan;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelColumnMapping;
import hive.org.apache.calcite.rel.metadata.RelColumnOrigin;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.util.HashSet;
import java.util.Set;

public class RelMdColumnOrigins {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLUMN_ORIGIN.method, new RelMdColumnOrigins());

    private RelMdColumnOrigins() {
    }

    public Set<RelColumnOrigin> getColumnOrigins(Aggregate rel, int iOutputColumn) {
        if (iOutputColumn < rel.getGroupCount()) {
            return this.invokeGetColumnOrigins(rel.getInput(), iOutputColumn);
        }
        if (rel.indicator && iOutputColumn < rel.getGroupCount() + rel.getIndicatorCount()) {
            return ImmutableSet.of();
        }
        AggregateCall call = rel.getAggCallList().get(iOutputColumn - rel.getGroupCount() - rel.getIndicatorCount());
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (Integer iInput : call.getArgList()) {
            Set<RelColumnOrigin> inputSet = this.invokeGetColumnOrigins(rel.getInput(), iInput);
            if ((inputSet = this.createDerivedColumnOrigins(inputSet)) == null) continue;
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(Join rel, int iOutputColumn) {
        Set<RelColumnOrigin> set;
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        boolean derived = false;
        if (iOutputColumn < nLeftColumns) {
            set = this.invokeGetColumnOrigins(rel.getLeft(), iOutputColumn);
            if (rel.getJoinType().generatesNullsOnLeft()) {
                derived = true;
            }
        } else {
            set = this.invokeGetColumnOrigins(rel.getRight(), iOutputColumn - nLeftColumns);
            if (rel.getJoinType().generatesNullsOnRight()) {
                derived = true;
            }
        }
        if (derived) {
            set = this.createDerivedColumnOrigins(set);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(SetOp rel, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelNode input : rel.getInputs()) {
            Set<RelColumnOrigin> inputSet = this.invokeGetColumnOrigins(input, iOutputColumn);
            if (inputSet == null) {
                return null;
            }
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(Project rel, int iOutputColumn) {
        final RelNode child = rel.getInput();
        RexNode rexNode = rel.getProjects().get(iOutputColumn);
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return this.invokeGetColumnOrigins(child, inputRef.getIndex());
        }
        final HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                Set<RelColumnOrigin> inputSet = RelMdColumnOrigins.this.invokeGetColumnOrigins(child, inputRef.getIndex());
                if (inputSet != null) {
                    set.addAll(inputSet);
                }
                return null;
            }
        };
        rexNode.accept(visitor);
        return this.createDerivedColumnOrigins(set);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Filter rel, int iOutputColumn) {
        return this.invokeGetColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Sort rel, int iOutputColumn) {
        return this.invokeGetColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(Exchange rel, int iOutputColumn) {
        return this.invokeGetColumnOrigins(rel.getInput(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(TableFunctionScan rel, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        Set<RelColumnMapping> mappings = rel.getColumnMappings();
        if (mappings == null) {
            if (rel.getInputs().size() > 0) {
                return null;
            }
            return set;
        }
        for (RelColumnMapping mapping : mappings) {
            if (mapping.iOutputColumn != iOutputColumn) continue;
            Set<RelColumnOrigin> origins = this.invokeGetColumnOrigins(rel.getInputs().get(mapping.iInputRel), mapping.iInputColumn);
            if (origins == null) {
                return null;
            }
            if (mapping.derived) {
                origins = this.createDerivedColumnOrigins(origins);
            }
            set.addAll(origins);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int iOutputColumn) {
        if (rel.getInputs().size() > 0) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RelOptTable table = rel.getTable();
        if (table == null) {
            return set;
        }
        if (table.getRowType() != rel.getRowType()) {
            return null;
        }
        set.add(new RelColumnOrigin(table, iOutputColumn, false));
        return set;
    }

    protected Set<RelColumnOrigin> invokeGetColumnOrigins(RelNode rel, int iOutputColumn) {
        return RelMetadataQuery.getColumnOrigins(rel, iOutputColumn);
    }

    private Set<RelColumnOrigin> createDerivedColumnOrigins(Set<RelColumnOrigin> inputSet) {
        if (inputSet == null) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelColumnOrigin rco : inputSet) {
            RelColumnOrigin derived = new RelColumnOrigin(rco.getOriginTable(), rco.getOriginColumnOrdinal(), true);
            set.add(derived);
        }
        return set;
    }
}

