/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.LinkedListMultimap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Ordering;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.plan.volcano.RelSubset;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.SortExchange;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.core.Window;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexCallBinding;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class RelMdCollation {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLLATIONS.method, new RelMdCollation());

    private RelMdCollation() {
    }

    public ImmutableList<RelCollation> collations(RelNode rel) {
        return ImmutableList.of();
    }

    public ImmutableList<RelCollation> collations(Window rel) {
        return ImmutableList.copyOf(RelMdCollation.window(rel.getInput(), rel.groups));
    }

    public ImmutableList<RelCollation> collations(Filter rel) {
        return RelMetadataQuery.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableScan scan) {
        return ImmutableList.copyOf(RelMdCollation.table(scan.getTable()));
    }

    public ImmutableList<RelCollation> collations(EnumerableMergeJoin join) {
        return ImmutableList.copyOf(RelMdCollation.mergeJoin(join.getLeft(), join.getRight(), join.getLeftKeys(), join.getRightKeys()));
    }

    public ImmutableList<RelCollation> collations(Sort sort) {
        return ImmutableList.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(SortExchange sort) {
        return ImmutableList.copyOf(RelMdCollation.sort(sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Project project) {
        return ImmutableList.copyOf(RelMdCollation.project(project.getInput(), project.getProjects()));
    }

    public ImmutableList<RelCollation> collations(Values values) {
        return ImmutableList.copyOf(RelMdCollation.values(values.getRowType(), values.getTuples()));
    }

    public ImmutableList<RelCollation> collations(HepRelVertex rel) {
        return RelMetadataQuery.collations(rel.getCurrentRel());
    }

    public ImmutableList<RelCollation> collations(RelSubset rel) {
        return ImmutableList.copyOf(rel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE));
    }

    public static List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static List<RelCollation> sort(RelCollation collation) {
        return ImmutableList.of(collation);
    }

    public static List<RelCollation> filter(RelNode input) {
        return RelMetadataQuery.collations(input);
    }

    public static List<RelCollation> limit(RelNode input) {
        return RelMetadataQuery.collations(input);
    }

    public static List<RelCollation> calc(RelNode input, RexProgram program) {
        return program.getCollations(RelMetadataQuery.collations(input));
    }

    public static List<RelCollation> project(RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = Sets.newTreeSet();
        ImmutableList<RelCollation> inputCollations = RelMetadataQuery.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedListMultimap<Integer, Integer> targets = LinkedListMultimap.create();
        HashMap<Integer, SqlMonotonicity> targetsWithMonotonicity = new HashMap<Integer, SqlMonotonicity>();
        for (Ord project : Ord.zip(projects)) {
            if (project.e instanceof RexInputRef) {
                targets.put(((RexInputRef)project.e).getIndex(), project.i);
                continue;
            }
            if (!(project.e instanceof RexCall)) continue;
            RexCall call = (RexCall)project.e;
            RexCallBinding binding = RexCallBinding.create(input.getCluster().getTypeFactory(), call, inputCollations);
            targetsWithMonotonicity.put(project.i, call.getOperator().getMonotonicity(binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = Lists.newArrayList();
        block4: for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                Collection integers = targets.get(ifc.getFieldIndex());
                if (integers.isEmpty()) continue block4;
                fieldCollations.add(ifc.copy((Integer)integers.iterator().next()));
            }
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> fieldCollationsForRexCalls = new ArrayList<RelFieldCollation>();
        block6: for (Map.Entry entry : targetsWithMonotonicity.entrySet()) {
            SqlMonotonicity value = (SqlMonotonicity)((Object)entry.getValue());
            switch (value) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            fieldCollationsForRexCalls.add(new RelFieldCollation((Integer)entry.getKey(), RelFieldCollation.Direction.of(value)));
        }
        if (!fieldCollationsForRexCalls.isEmpty()) {
            collations.add(RelCollations.of(fieldCollationsForRexCalls));
        }
        return ImmutableList.copyOf(collations);
    }

    public static List<RelCollation> window(RelNode input, ImmutableList<Window.Group> groups) {
        return RelMetadataQuery.collations(input);
    }

    public static List<RelCollation> values(RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        ArrayList<RelCollation> list = Lists.newArrayList();
        int n = rowType.getFieldCount();
        ArrayList<Pair<RelFieldCollation, Ordering<List<RexLiteral>>>> pairs = Lists.newArrayList();
        block0: for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Ordering<List<RexLiteral>> comparator = RelMdCollation.comparator(fieldCollation);
                Ordering<List<RexLiteral>> ordering = pairs.isEmpty() ? comparator : ((Ordering)((Pair)Util.last(pairs)).right).compound(comparator);
                pairs.add(Pair.of(fieldCollation, ordering));
                if (ordering.isOrdered(tuples)) continue;
                if (j == i) continue block0;
                pairs.remove(pairs.size() - 1);
            }
            if (pairs.isEmpty()) continue;
            list.add(RelCollations.of(Pair.left(pairs)));
        }
        return list;
    }

    private static Ordering<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Ordering<List<RexLiteral>>(){

                    @Override
                    public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                        Comparable c1 = o1.get(x).getValue();
                        Comparable c2 = o2.get(x).getValue();
                        return RelFieldCollation.compare(c1, c2, nullComparison);
                    }
                };
            }
        }
        return new Ordering<List<RexLiteral>>(){

            @Override
            public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                Comparable c1 = o1.get(x).getValue();
                Comparable c2 = o2.get(x).getValue();
                return RelFieldCollation.compare(c2, c1, -nullComparison);
            }
        };
    }

    public static List<RelCollation> mergeJoin(RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<RelCollation> leftCollations = RelMetadataQuery.collations(left);
        assert (RelCollations.contains(leftCollations, leftKeys)) : "cannot merge join: left input is not sorted on left keys";
        builder.addAll(leftCollations);
        ImmutableList<RelCollation> rightCollations = RelMetadataQuery.collations(right);
        assert (RelCollations.contains(rightCollations, rightKeys)) : "cannot merge join: right input is not sorted on right keys";
        int leftFieldCount = left.getRowType().getFieldCount();
        for (RelCollation collation : rightCollations) {
            builder.add(RelCollations.shift(collation, leftFieldCount));
        }
        return builder.build();
    }
}

