/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Function;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CachingRelMetadataProvider
implements RelMetadataProvider {
    private final Map<List, CacheEntry> cache;
    private final RelMetadataProvider underlyingProvider;
    private final RelOptPlanner planner;
    private static final Object NULL_SENTINEL = new Object(){

        public String toString() {
            return "{null}";
        }
    };

    public CachingRelMetadataProvider(RelMetadataProvider underlyingProvider, RelOptPlanner planner) {
        this.underlyingProvider = underlyingProvider;
        this.planner = planner;
        this.cache = new HashMap<List, CacheEntry>();
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, final Class<? extends Metadata> metadataClass) {
        final Function<RelNode, Metadata> function = this.underlyingProvider.apply(relClass, metadataClass);
        if (function == null) {
            return null;
        }
        return new Function<RelNode, Metadata>(){

            @Override
            public Metadata apply(RelNode input) {
                Metadata metadata = (Metadata)function.apply(input);
                return (Metadata)Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new CachingInvocationHandler(metadata));
            }
        };
    }

    private class CachingInvocationHandler
    implements InvocationHandler {
        private final Metadata metadata;

        public CachingInvocationHandler(Metadata metadata) {
            this.metadata = Preconditions.checkNotNull(metadata);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(method);
            builder.add(this.metadata.rel());
            if (args != null) {
                for (Object arg : args) {
                    builder.add(arg == null ? NULL_SENTINEL : arg);
                }
            }
            ImmutableCollection key = builder.build();
            long timestamp = CachingRelMetadataProvider.this.planner.getRelMetadataTimestamp(this.metadata.rel());
            CacheEntry entry = (CacheEntry)CachingRelMetadataProvider.this.cache.get(key);
            if (entry != null && timestamp == entry.timestamp) {
                return entry.result;
            }
            Object result = method.invoke((Object)this.metadata, args);
            if (result != null) {
                entry = new CacheEntry();
                entry.timestamp = timestamp;
                entry.result = result;
                CachingRelMetadataProvider.this.cache.put(key, entry);
            }
            return result;
        }
    }

    private static class CacheEntry {
        long timestamp;
        Object result;

        private CacheEntry() {
        }
    }
}

