/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel;

import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitDef;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalSort;

public class RelCollationTraitDef
extends RelTraitDef<RelCollation> {
    public static final RelCollationTraitDef INSTANCE = new RelCollationTraitDef();

    private RelCollationTraitDef() {
    }

    @Override
    public Class<RelCollation> getTraitClass() {
        return RelCollation.class;
    }

    @Override
    public String getSimpleName() {
        return "sort";
    }

    @Override
    public boolean multiple() {
        return true;
    }

    @Override
    public RelCollation getDefault() {
        return RelCollations.EMPTY;
    }

    @Override
    public RelNode convert(RelOptPlanner planner, RelNode rel, RelCollation toCollation, boolean allowInfiniteCostConverters) {
        if (toCollation == RelCollations.PRESERVE) {
            return null;
        }
        if (toCollation.getFieldCollations().isEmpty()) {
            return null;
        }
        LogicalSort sort = LogicalSort.create(rel, toCollation, null, null);
        RelNode newRel = planner.register(sort, rel);
        RelTraitSet newTraitSet = rel.getTraitSet().replace(toCollation);
        if (!newRel.getTraitSet().equals(newTraitSet)) {
            newRel = planner.changeTraits(newRel, newTraitSet);
        }
        return newRel;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, RelCollation fromTrait, RelCollation toTrait) {
        return toTrait != RelCollations.PRESERVE;
    }
}

