/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.prepare;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.Collections2;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Iterables;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.jdbc.CalciteSchema;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptSchema;
import hive.org.apache.calcite.prepare.Prepare;
import hive.org.apache.calcite.prepare.RelOptTableImpl;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.schema.AggregateFunction;
import hive.org.apache.calcite.schema.FunctionParameter;
import hive.org.apache.calcite.schema.ScalarFunction;
import hive.org.apache.calcite.schema.Schemas;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.TableFunction;
import hive.org.apache.calcite.schema.TableMacro;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlOperatorTable;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.sql.type.InferTypes;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeFamily;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.sql.validate.SqlMonikerImpl;
import hive.org.apache.calcite.sql.validate.SqlMonikerType;
import hive.org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import hive.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import hive.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import hive.org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import hive.org.apache.calcite.sql.validate.SqlValidatorUtil;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;

public class CalciteCatalogReader
implements Prepare.CatalogReader,
SqlOperatorTable {
    final CalciteSchema rootSchema;
    final JavaTypeFactory typeFactory;
    private final List<String> defaultSchema;
    private final boolean elideRecord = true;
    private final boolean caseSensitive;

    public CalciteCatalogReader(CalciteSchema rootSchema, boolean caseSensitive, List<String> defaultSchema, JavaTypeFactory typeFactory) {
        assert (rootSchema != defaultSchema);
        this.rootSchema = rootSchema;
        this.caseSensitive = caseSensitive;
        this.defaultSchema = defaultSchema;
        this.typeFactory = typeFactory;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.caseSensitive, schemaPath, this.typeFactory);
    }

    @Override
    public RelOptTableImpl getTable(List<String> names) {
        RelOptTableImpl table;
        if (this.defaultSchema != null && (table = this.getTableFrom(names, this.defaultSchema)) != null) {
            return table;
        }
        return this.getTableFrom(names, ImmutableList.of());
    }

    private RelOptTableImpl getTableFrom(List<String> names, List<String> schemaNames) {
        CalciteSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)));
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        CalciteSchema.TableEntry entry = schema.getTable(name, this.caseSensitive);
        if (entry == null) {
            entry = schema.getTableBasedOnNullaryFunction(name, this.caseSensitive);
        }
        if (entry != null) {
            Table table = entry.getTable();
            String name2 = entry.name;
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), schema.add(name2, table), null);
        }
        return null;
    }

    private Collection<hive.org.apache.calcite.schema.Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList<hive.org.apache.calcite.schema.Function> functions2 = Lists.newArrayList();
        List<Object> schemaNameList = names.size() > 1 ? ImmutableList.of(ImmutableList.of()) : ((schema = this.getSchema(this.defaultSchema)) == null ? ImmutableList.of() : schema.getPath());
        for (List list : schemaNameList) {
            CalciteSchema schema2 = this.getSchema(Iterables.concat(list, Util.skipLast(names)));
            if (schema2 == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema2.getFunctions(name, true));
        }
        return functions2;
    }

    private CalciteSchema getSchema(Iterable<String> schemaNames) {
        CalciteSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if ((schema = schema.getSubSchema(schemaName, this.caseSensitive)) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = this.getSchema(names);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(new SqlMonikerImpl(schema.path(subSchema), SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(new SqlMonikerImpl(schema.path(table), SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(new SqlMonikerImpl(schema.path(function), SqlMonikerType.FUNCTION));
        }
        return result;
    }

    @Override
    public List<String> getSchemaName() {
        return this.defaultSchema;
    }

    @Override
    public RelOptTableImpl getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return SqlValidatorUtil.lookupField(this.caseSensitive, true, rowType, alias);
    }

    @Override
    public int fieldOrdinal(RelDataType rowType, String alias) {
        RelDataTypeField field = this.field(rowType, alias);
        return field != null ? field.getIndex() : -1;
    }

    @Override
    public boolean matches(String string, String name) {
        return Util.matches(this.caseSensitive, string, name);
    }

    @Override
    public int match(List<String> strings, String name) {
        return Util.findMatch(strings, name, this.caseSensitive);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.caseSensitive, true);
    }

    @Override
    public void lookupOperatorOverloads(final SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        Collection<hive.org.apache.calcite.schema.Function> functions = this.getFunctionsFrom(opName.names);
        if (functions.isEmpty()) {
            return;
        }
        operatorList.addAll(Collections2.transform(functions, new Function<hive.org.apache.calcite.schema.Function, SqlOperator>(){

            @Override
            public SqlOperator apply(hive.org.apache.calcite.schema.Function function) {
                return CalciteCatalogReader.this.toOp(opName, function);
            }
        }));
    }

    private SqlOperator toOp(SqlIdentifier name, hive.org.apache.calcite.schema.Function function) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        if (function instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, (SqlReturnTypeInference)ReturnTypes.explicit(Schemas.proto((ScalarFunction)function)), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), function);
        }
        if (function instanceof AggregateFunction) {
            RelDataType returnType = ((AggregateFunction)function).getReturnType(this.typeFactory);
            return new SqlUserDefinedAggFunction(name, ReturnTypes.explicit(returnType), InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (AggregateFunction)function);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, new Function<RelDataType, RelDataType>(){

            @Override
            public RelDataType apply(RelDataType input) {
                if (input instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)input).getJavaClass() == Object.class) {
                    return CalciteCatalogReader.this.typeFactory.createTypeWithNullability(CalciteCatalogReader.this.typeFactory.createSqlType(SqlTypeName.ANY), true);
                }
                return CalciteCatalogReader.this.typeFactory.toSql(input);
            }
        });
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }
}

