/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;

public class Strong {
    private final ImmutableBitSet nullColumns;

    private Strong(ImmutableBitSet nullColumns) {
        this.nullColumns = nullColumns;
    }

    public static Strong of(ImmutableBitSet nullColumns) {
        return new Strong(nullColumns);
    }

    public static boolean is(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).strong(node);
    }

    private boolean strong(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).getValue() == null;
            }
            case IS_TRUE: 
            case IS_NOT_NULL: 
            case AND: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.anyStrong(((RexCall)node).getOperands());
            }
            case OR: {
                return this.allStrong(((RexCall)node).getOperands());
            }
            case INPUT_REF: {
                return this.nullColumns.get(((RexInputRef)node).getIndex());
            }
        }
        return false;
    }

    private boolean allStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.strong(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.strong(operand)) continue;
            return true;
        }
        return false;
    }
}

