/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.materialize;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.materialize.LatticeStatisticProvider;
import hive.org.apache.calcite.materialize.MaterializationService;
import hive.org.apache.calcite.schema.ScannableTable;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.util.ImmutableBitSet;

class SqlLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final SqlLatticeStatisticProvider INSTANCE = new SqlLatticeStatisticProvider();

    private SqlLatticeStatisticProvider() {
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        String sql = lattice.countSql(ImmutableBitSet.of(column.ordinal));
        Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, ImmutableList.of());
        Object[] values = Iterables.getOnlyElement(((ScannableTable)table).scan(null));
        return ((Number)values[0]).intValue();
    }
}

