/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.org.apache.calcite.avatica.AvaticaResultSet;
import hive.org.apache.calcite.avatica.AvaticaStatement;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.jdbc.CalciteConnectionImpl;
import hive.org.apache.calcite.jdbc.CalcitePrepare;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.server.CalciteServerStatement;
import java.sql.SQLException;

public abstract class CalciteStatement
extends AvaticaStatement {
    CalciteStatement(CalciteConnectionImpl connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == CalciteServerStatement.class) {
            return (T)this.getConnection().server.getStatement(this.handle);
        }
        return super.unwrap(iface);
    }

    @Override
    public CalciteConnectionImpl getConnection() {
        return (CalciteConnectionImpl)this.connection;
    }

    public CalciteConnectionImpl.ContextImpl createPrepareContext() {
        return new CalciteConnectionImpl.ContextImpl(this.getConnection());
    }

    protected <T> CalcitePrepare.CalciteSignature<T> prepare(Queryable<T> queryable) {
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalcitePrepare prepare = (CalcitePrepare)calciteConnection.prepareFactory.apply();
        CalciteServerStatement serverStatement = calciteConnection.server.getStatement(this.handle);
        CalcitePrepare.Context prepareContext = serverStatement.createPrepareContext();
        return prepare.prepareQueryable(prepareContext, queryable);
    }

    @Override
    protected void close_() {
        if (!this.closed) {
            this.closed = true;
            CalciteConnectionImpl connection1 = (CalciteConnectionImpl)this.connection;
            connection1.server.removeStatement(this.handle);
            if (this.openResultSet != null) {
                AvaticaResultSet c = this.openResultSet;
                this.openResultSet = null;
                c.close();
            }
            connection1.getDriver().handler.onStatementClose(this);
        }
    }
}

