/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.avatica.AvaticaResultSet;
import hive.org.apache.calcite.avatica.AvaticaStatement;
import hive.org.apache.calcite.avatica.ColumnMetaData;
import hive.org.apache.calcite.avatica.Handler;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.avatica.util.Cursor;
import hive.org.apache.calcite.jdbc.CalciteConnectionImpl;
import hive.org.apache.calcite.jdbc.CalcitePrepare;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.runtime.ArrayEnumeratorCursor;
import hive.org.apache.calcite.runtime.ObjectEnumeratorCursor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;

public class CalciteResultSet
extends AvaticaResultSet {
    CalciteResultSet(AvaticaStatement statement, CalcitePrepare.CalciteSignature calciteSignature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) {
        super(statement, calciteSignature, resultSetMetaData, timeZone, firstFrame);
    }

    @Override
    protected CalciteResultSet execute() throws SQLException {
        CalciteConnectionImpl connection = this.getCalciteConnection();
        boolean autoTemp = connection.config().autoTemp();
        Handler.ResultSink resultSink = null;
        if (autoTemp) {
            resultSink = new Handler.ResultSink(){

                @Override
                public void toBeCompleted() {
                }
            };
        }
        connection.getDriver().handler.onStatementExecute(this.statement, resultSink);
        super.execute();
        return this;
    }

    @Override
    public ResultSet create(ColumnMetaData.AvaticaType elementType, Iterable<Object> iterable) {
        CalciteResultSet resultSet = new CalciteResultSet(this.statement, (CalcitePrepare.CalciteSignature)this.signature, this.resultSetMetaData, this.localCalendar.getTimeZone(), new Meta.Frame(0L, true, iterable));
        Cursor cursor = resultSet.createCursor(elementType, iterable);
        List<ColumnMetaData> columnMetaDataList = elementType instanceof ColumnMetaData.StructType ? ((ColumnMetaData.StructType)elementType).columns : ImmutableList.of(ColumnMetaData.dummy(elementType, false));
        return resultSet.execute2(cursor, columnMetaDataList);
    }

    private Cursor createCursor(ColumnMetaData.AvaticaType elementType, Iterable iterable) {
        Enumerator enumerator = Linq4j.iterableEnumerator((Iterable)iterable);
        return !(elementType instanceof ColumnMetaData.StructType) || ((ColumnMetaData.StructType)elementType).columns.size() == 1 ? new ObjectEnumeratorCursor((Enumerator<Object>)enumerator) : new ArrayEnumeratorCursor((Enumerator<Object[]>)enumerator);
    }

    <T> CalcitePrepare.CalciteSignature<T> getSignature() {
        return (CalcitePrepare.CalciteSignature)this.signature;
    }

    CalciteConnectionImpl getCalciteConnection() {
        return (CalciteConnectionImpl)this.statement.getConnection();
    }
}

