/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.interpreter;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.interpreter.Context;
import hive.org.apache.calcite.interpreter.Interpreter;
import hive.org.apache.calcite.interpreter.Scalar;
import hive.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.ClassDeclaration;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.MemberExpression;
import hive.org.apache.calcite.linq4j.tree.MethodDeclaration;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexProgramBuilder;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression context_ = Expressions.parameter(Context.class, (String)"context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, (String)"outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(Expressions.field((Expression)context_, (Field)BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false))));
        Function1<String, RexToLixTranslator.InputGetter> correlates = new Function1<String, RexToLixTranslator.InputGetter>(){

            public RexToLixTranslator.InputGetter apply(String a0) {
                throw new UnsupportedOperationException();
            }
        };
        MemberExpression root = Expressions.field((Expression)context_, (Field)BuiltInMethod.CONTEXT_ROOT.field);
        List<Expression> list = RexToLixTranslator.translateProjects(program, javaTypeFactory, builder, null, (Expression)root, inputGetter, correlates);
        for (int i = 0; i < list.size(); ++i) {
            builder.add(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.arrayIndex((Expression)outputValues_, (Expression)Expressions.constant((Object)i)), (Expression)list.get(i))));
        }
        return JaninoRexCompiler.baz(context_, outputValues_, builder.toBlock());
    }

    static Scalar baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block) {
        ArrayList<MethodDeclaration> declarations = Lists.newArrayList();
        declarations.add(Expressions.methodDecl((int)1, Void.TYPE, (String)BuiltInMethod.SCALAR_EXECUTE2.method.getName(), ImmutableList.of(context_, outputValues_), (BlockStatement)block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", (Expression)Expressions.newArrayBounds(Object.class, (int)1, (Expression)Expressions.constant((Object)1)));
        builder.add(Expressions.statement((Expression)Expressions.call((Expression)Expressions.parameter(Scalar.class, (String)"this"), (Method)BuiltInMethod.SCALAR_EXECUTE2.method, (Expression[])new Expression[]{context_, values_})));
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.arrayIndex((Expression)values_, (Expression)Expressions.constant((Object)0))));
        declarations.add(Expressions.methodDecl((int)1, Object.class, (String)BuiltInMethod.SCALAR_EXECUTE1.method.getName(), ImmutableList.of(context_), (BlockStatement)builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl((int)1, (String)"Buzz", null, ImmutableList.of(Scalar.class), declarations);
        String s = Expressions.toString(declarations, (String)"\n", (boolean)false);
        if (CalcitePrepareImpl.DEBUG) {
            Util.debugCode(System.out, s);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s);
        }
        catch (CompileException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar getScalar(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.class});
        cbe.setParentClassLoader(JaninoRexCompiler.class.getClassLoader());
        if (CalcitePrepareImpl.DEBUG) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar)cbe.createInstance((Reader)new StringReader(s));
    }
}

