/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.interpreter;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.interpreter.Context;
import hive.org.apache.calcite.interpreter.JaninoRexCompiler;
import hive.org.apache.calcite.interpreter.Node;
import hive.org.apache.calcite.interpreter.Nodes;
import hive.org.apache.calcite.interpreter.Row;
import hive.org.apache.calcite.interpreter.Scalar;
import hive.org.apache.calcite.interpreter.Sink;
import hive.org.apache.calcite.interpreter.Source;
import hive.org.apache.calcite.linq4j.AbstractEnumerable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.plan.hep.HepPlanner;
import hive.org.apache.calcite.plan.hep.HepProgram;
import hive.org.apache.calcite.plan.hep.HepProgramBuilder;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelVisitor;
import hive.org.apache.calcite.rel.rules.CalcSplitRule;
import hive.org.apache.calcite.rel.rules.FilterTableScanRule;
import hive.org.apache.calcite.rel.rules.ProjectTableScanRule;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.ReflectUtil;
import hive.org.apache.calcite.util.ReflectiveVisitDispatcher;
import hive.org.apache.calcite.util.ReflectiveVisitor;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class Interpreter
extends AbstractEnumerable<Object[]> {
    final Map<RelNode, NodeInfo> nodes = Maps.newLinkedHashMap();
    private final DataContext dataContext;
    private final RelNode rootRel;
    private final Map<RelNode, List<RelNode>> relInputs = Maps.newHashMap();
    protected final ScalarCompiler scalarCompiler;

    public Interpreter(DataContext dataContext, RelNode rootRel) {
        this.dataContext = Preconditions.checkNotNull(dataContext);
        this.scalarCompiler = new JaninoRexCompiler(rootRel.getCluster().getRexBuilder());
        RelNode rel = this.optimize(rootRel);
        Nodes.CoreCompiler compiler = new Nodes.CoreCompiler(this);
        this.rootRel = compiler.visitRoot(rel);
    }

    private RelNode optimize(RelNode rootRel) {
        HepProgram hepProgram = new HepProgramBuilder().addRuleInstance(CalcSplitRule.INSTANCE).addRuleInstance(FilterTableScanRule.INSTANCE).addRuleInstance(FilterTableScanRule.INTERPRETER).addRuleInstance(ProjectTableScanRule.INSTANCE).addRuleInstance(ProjectTableScanRule.INTERPRETER).build();
        HepPlanner planner = new HepPlanner(hepProgram);
        planner.setRoot(rootRel);
        rootRel = planner.findBestExp();
        return rootRel;
    }

    public Enumerator<Object[]> enumerator() {
        this.start();
        final ArrayDeque<Row> queue = this.nodes.get((Object)this.rootRel).sink.list;
        return new Enumerator<Object[]>(){
            Row row;

            public Object[] current() {
                return this.row.getValues();
            }

            public boolean moveNext() {
                try {
                    this.row = (Row)queue.removeFirst();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
                return true;
            }

            public void reset() {
                this.row = null;
            }

            public void close() {
                Interpreter.this.close();
            }
        };
    }

    private void start() {
        for (Map.Entry<RelNode, NodeInfo> entry : this.nodes.entrySet()) {
            NodeInfo nodeInfo = entry.getValue();
            try {
                nodeInfo.node.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void close() {
    }

    public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
        if (inputRowType == null) {
            inputRowType = this.dataContext.getTypeFactory().builder().build();
        }
        return this.scalarCompiler.compile(nodes, inputRowType);
    }

    RelDataType combinedRowType(List<RelNode> inputs) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.dataContext.getTypeFactory().builder();
        for (RelNode input : inputs) {
            builder.addAll(input.getRowType().getFieldList());
        }
        return builder.build();
    }

    public Source source(RelNode rel, int ordinal) {
        RelNode input = this.getInput(rel, ordinal);
        NodeInfo x = this.nodes.get(input);
        if (x == null) {
            throw new AssertionError((Object)("should be registered: " + rel));
        }
        return new ListSource(x.sink);
    }

    private RelNode getInput(RelNode rel, int ordinal) {
        List<RelNode> inputs = this.relInputs.get(rel);
        if (inputs != null) {
            return inputs.get(ordinal);
        }
        return rel.getInput(ordinal);
    }

    public Sink sink(RelNode rel) {
        ArrayDeque queue = new ArrayDeque(1);
        ListSink sink = new ListSink(queue);
        NodeInfo nodeInfo = new NodeInfo(rel, sink);
        this.nodes.put(rel, nodeInfo);
        return sink;
    }

    public Context createContext() {
        return new Context(this.dataContext);
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    static interface ScalarCompiler {
        public Scalar compile(List<RexNode> var1, RelDataType var2);
    }

    public static class Compiler
    extends RelVisitor
    implements ReflectiveVisitor {
        private final ReflectiveVisitDispatcher<Compiler, RelNode> dispatcher = ReflectUtil.createDispatcher(Compiler.class, RelNode.class);
        protected final Interpreter interpreter;
        protected RelNode rootRel;
        protected RelNode rel;
        protected Node node;
        private static final String REWRITE_METHOD_NAME = "rewrite";
        private static final String VISIT_METHOD_NAME = "visit";

        Compiler(Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        public RelNode visitRoot(RelNode p) {
            this.rootRel = p;
            this.visit(p, 0, null);
            return this.rootRel;
        }

        @Override
        public void visit(RelNode p, int ordinal, RelNode parent) {
            while (true) {
                this.rel = null;
                boolean found = this.dispatcher.invokeVisitor(this, p, REWRITE_METHOD_NAME);
                if (!found) {
                    throw new AssertionError((Object)"interpreter: no implementation for rewrite");
                }
                if (this.rel == null) break;
                if (CalcitePrepareImpl.DEBUG) {
                    System.out.println("Interpreter: rewrite " + p + " to " + this.rel);
                }
                p = this.rel;
                if (parent != null) {
                    ArrayList<RelNode> inputs = (ArrayList<RelNode>)this.interpreter.relInputs.get(parent);
                    if (inputs == null) {
                        inputs = Lists.newArrayList(parent.getInputs());
                        this.interpreter.relInputs.put(parent, inputs);
                    }
                    inputs.set(ordinal, p);
                    continue;
                }
                this.rootRel = p;
            }
            List inputs = (List)this.interpreter.relInputs.get(p);
            if (inputs != null) {
                for (int i = 0; i < inputs.size(); ++i) {
                    RelNode input = (RelNode)inputs.get(i);
                    this.visit(input, i, p);
                }
            } else {
                p.childrenAccept(this);
            }
            this.node = null;
            boolean found = this.dispatcher.invokeVisitor(this, p, VISIT_METHOD_NAME);
            if (!found) {
                throw new AssertionError((Object)("interpreter: no implementation for " + p.getClass()));
            }
            NodeInfo nodeInfo = this.interpreter.nodes.get(p);
            assert (nodeInfo != null);
            nodeInfo.node = this.node;
        }

        public void rewrite(RelNode r) {
        }
    }

    private static class ListSource
    implements Source {
        private final ArrayDeque<Row> list;

        public ListSource(ListSink sink) {
            this.list = sink.list;
        }

        @Override
        public Row receive() {
            try {
                return this.list.remove();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    private static class ListSink
    implements Sink {
        final ArrayDeque<Row> list;

        private ListSink(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public void send(Row row) throws InterruptedException {
            this.list.add(row);
        }

        @Override
        public void end() throws InterruptedException {
        }
    }

    private static class NodeInfo {
        final RelNode rel;
        final ListSink sink;
        Node node;

        public NodeInfo(RelNode rel, ListSink sink) {
            this.rel = rel;
            this.sink = sink;
        }
    }

    private class FooCompiler
    implements ScalarCompiler {
        private FooCompiler() {
        }

        @Override
        public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
            final RexNode node = nodes.get(0);
            if (node instanceof RexCall) {
                final RexCall call = (RexCall)node;
                final Scalar argScalar = this.compile(call.getOperands(), inputRowType);
                return new Scalar(){
                    final Object[] args;
                    {
                        this.args = new Object[call.getOperands().size()];
                    }

                    @Override
                    public void execute(Context context, Object[] results) {
                        results[0] = this.execute(context);
                    }

                    @Override
                    public Object execute(Context context) {
                        switch (call.getKind()) {
                            case LESS_THAN: 
                            case LESS_THAN_OR_EQUAL: 
                            case GREATER_THAN: 
                            case GREATER_THAN_OR_EQUAL: 
                            case EQUALS: 
                            case NOT_EQUALS: {
                                argScalar.execute(context, this.args);
                                Comparable o0 = (Comparable)this.args[0];
                                if (o0 == null) {
                                    return null;
                                }
                                Comparable o1 = (Comparable)this.args[1];
                                if (o1 == null) {
                                    return null;
                                }
                                if (o0 instanceof BigDecimal) {
                                    o1 = o1 instanceof Double || o1 instanceof Float ? new BigDecimal(((Number)((Object)o1)).doubleValue()) : new BigDecimal(((Number)((Object)o1)).longValue());
                                }
                                if (o1 instanceof BigDecimal) {
                                    o0 = o0 instanceof Double || o0 instanceof Float ? new BigDecimal(((Number)((Object)o0)).doubleValue()) : new BigDecimal(((Number)((Object)o0)).longValue());
                                }
                                int c = o0.compareTo(o1);
                                switch (call.getKind()) {
                                    case LESS_THAN: {
                                        return c < 0;
                                    }
                                    case LESS_THAN_OR_EQUAL: {
                                        return c <= 0;
                                    }
                                    case GREATER_THAN: {
                                        return c > 0;
                                    }
                                    case GREATER_THAN_OR_EQUAL: {
                                        return c >= 0;
                                    }
                                    case EQUALS: {
                                        return c == 0;
                                    }
                                    case NOT_EQUALS: {
                                        return c != 0;
                                    }
                                }
                                throw new AssertionError((Object)("unknown expression " + call));
                            }
                        }
                        if (call.getOperator() == SqlStdOperatorTable.UPPER) {
                            argScalar.execute(context, this.args);
                            String s0 = (String)this.args[0];
                            if (s0 == null) {
                                return null;
                            }
                            return s0.toUpperCase();
                        }
                        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
                            argScalar.execute(context, this.args);
                            String s0 = (String)this.args[0];
                            Number i1 = (Number)this.args[1];
                            Number i2 = (Number)this.args[2];
                            if (s0 == null || i1 == null || i2 == null) {
                                return null;
                            }
                            return s0.substring(i1.intValue() - 1, i1.intValue() - 1 + i2.intValue());
                        }
                        throw new AssertionError((Object)("unknown expression " + call));
                    }
                };
            }
            return new Scalar(){

                @Override
                public void execute(Context context, Object[] results) {
                    results[0] = this.execute(context);
                }

                @Override
                public Object execute(Context context) {
                    switch (node.getKind()) {
                        case LITERAL: {
                            return ((RexLiteral)node).getValue();
                        }
                        case INPUT_REF: {
                            return context.values[((RexInputRef)node).getIndex()];
                        }
                    }
                    throw new RuntimeException("unknown expression type " + node);
                }
            };
        }
    }
}

