/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.jdbc;

import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.cache.CacheLoader;
import hive.com.google.common.cache.LoadingCache;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.avatica.ColumnMetaData;
import hive.org.apache.calcite.linq4j.function.Function0;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.sql.SqlDialect;
import hive.org.apache.calcite.util.ImmutableNullableList;
import hive.org.apache.calcite.util.IntList;
import hive.org.apache.calcite.util.Pair;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

final class JdbcUtils {
    private JdbcUtils() {
        throw new AssertionError((Object)"no instances!");
    }

    public static class DataSourcePool {
        public static final DataSourcePool INSTANCE = new DataSourcePool();
        private final LoadingCache<List<String>, BasicDataSource> cache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<List<String>, BasicDataSource>(){

            @Override
            public BasicDataSource load(List<String> key) {
                BasicDataSource dataSource = new BasicDataSource();
                dataSource.setUrl(key.get(0));
                dataSource.setUsername(key.get(1));
                dataSource.setPassword(key.get(2));
                dataSource.setDriverClassName(key.get(3));
                return dataSource;
            }
        });

        public DataSource get(String url, String driverClassName, String username, String password) {
            List<String> key = ImmutableNullableList.of(url, username, password, driverClassName);
            return (DataSource)this.cache.apply(key);
        }
    }

    public static class ObjectArrayRowBuilder
    implements Function0<Object[]> {
        private final ResultSet resultSet;
        private final int columnCount;
        private final ColumnMetaData.Rep[] reps;
        private final int[] types;

        public ObjectArrayRowBuilder(ResultSet resultSet, ColumnMetaData.Rep[] reps, int[] types) throws SQLException {
            this.resultSet = resultSet;
            this.reps = reps;
            this.types = types;
            this.columnCount = resultSet.getMetaData().getColumnCount();
        }

        public static Function1<ResultSet, Function0<Object[]>> factory(final List<Pair<ColumnMetaData.Rep, Integer>> list) {
            return new Function1<ResultSet, Function0<Object[]>>(){

                public Function0<Object[]> apply(ResultSet resultSet) {
                    try {
                        return new ObjectArrayRowBuilder(resultSet, Pair.left(list).toArray(new ColumnMetaData.Rep[list.size()]), IntList.toArray(Pair.right(list)));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public Object[] apply() {
            try {
                Object[] values = new Object[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    values[i] = this.value(i);
                }
                return values;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private Object value(int i) throws SQLException {
            switch (this.types[i]) {
                case 93: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTimestamp(i + 1));
                }
                case 92: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTime(i + 1));
                }
                case 91: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getDate(i + 1));
                }
            }
            return this.reps[i].jdbcGet(this.resultSet, i + 1);
        }

        private static Timestamp shift(Timestamp v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Timestamp(time + (long)offset);
        }

        private static Time shift(Time v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Time((time + (long)offset) % 86400000L);
        }

        private static Date shift(Date v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Date(time + (long)offset);
        }
    }

    public static class DialectPool {
        final Map<DataSource, SqlDialect> map0 = new IdentityHashMap<DataSource, SqlDialect>();
        final Map<List, SqlDialect> map = new HashMap<List, SqlDialect>();
        public static final DialectPool INSTANCE = new DialectPool();

        SqlDialect get(DataSource dataSource) {
            SqlDialect sqlDialect = this.map0.get(dataSource);
            if (sqlDialect != null) {
                return sqlDialect;
            }
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String productName = metaData.getDatabaseProductName();
                String productVersion = metaData.getDatabaseProductVersion();
                ImmutableList<String> key = ImmutableList.of(productName, productVersion);
                SqlDialect dialect = this.map.get(key);
                if (dialect == null) {
                    SqlDialect.DatabaseProduct product = SqlDialect.getProduct(productName, productVersion);
                    dialect = new SqlDialect(product, productName, metaData.getIdentifierQuoteString());
                    this.map.put(key, dialect);
                    this.map0.put(dataSource, dialect);
                }
                connection.close();
                connection = null;
                SqlDialect sqlDialect2 = dialect;
                return sqlDialect2;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

