/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.AggImpState;
import hive.org.apache.calcite.adapter.enumerable.EnumUtils;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.enumerable.RexImpTable;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.adapter.enumerable.WinAggContext;
import hive.org.apache.calcite.adapter.enumerable.WinAggFrameResultContext;
import hive.org.apache.calcite.adapter.enumerable.WinAggImplementor;
import hive.org.apache.calcite.adapter.enumerable.impl.WinAggAddContextImpl;
import hive.org.apache.calcite.adapter.enumerable.impl.WinAggResetContextImpl;
import hive.org.apache.calcite.adapter.enumerable.impl.WinAggResultContextImpl;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.linq4j.tree.BinaryExpression;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.ConstantExpression;
import hive.org.apache.calcite.linq4j.tree.DeclarationStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.ForStatement;
import hive.org.apache.calcite.linq4j.tree.Node;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Primitive;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Window;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexWindowBound;
import hive.org.apache.calcite.runtime.SortedMultiMap;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class EnumerableWindow
extends Window
implements EnumerableRel {
    EnumerableWindow(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traits, child, constants, rowType, groups);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableWindow(this.getCluster(), traitSet, EnumerableWindow.sole(inputs), this.constants, this.rowType, this.groups);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(1.0);
    }

    private void sampleOfTheGeneratedWindowedAggregate() {
        Iterator iterator = null;
        Integer[] rows = (Integer[])iterator.next();
        int prevStart = -1;
        int prevEnd = -1;
        for (int i = 0; i < rows.length; ++i) {
            Integer row = rows[i];
            int start = 0;
            int end = 100;
            if (start == prevStart && end == prevEnd) continue;
            int actualStart = 0;
            actualStart = start != prevStart || end < prevEnd ? start : prevEnd + 1;
            prevStart = start;
            prevEnd = end;
            if (start == -1) continue;
            for (int j = actualStart; j <= end; ++j) {
            }
        }
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        EnumerableRel child = (EnumerableRel)this.getInput();
        BlockBuilder builder = new BlockBuilder();
        final EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression source_ = builder.append("source", result.block);
        ArrayList<Expression> translatedConstants = new ArrayList<Expression>(this.constants.size());
        for (RexLiteral constant : this.constants) {
            translatedConstants.add(RexToLixTranslator.translateLiteral(constant, constant.getType(), typeFactory, RexImpTable.NullAs.NULL));
        }
        PhysType inputPhysType = result.physType;
        ParameterExpression prevStart = Expressions.parameter(Integer.TYPE, (String)builder.newName("prevStart"));
        ParameterExpression prevEnd = Expressions.parameter(Integer.TYPE, (String)builder.newName("prevEnd"));
        builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)prevStart, null));
        builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)prevEnd, null));
        for (int windowIdx = 0; windowIdx < this.groups.size(); ++windowIdx) {
            ConstantExpression hasRows;
            Expression endX;
            Expression startX;
            Window.Group group = (Window.Group)this.groups.get(windowIdx);
            Expression comparator_ = builder.append("comparator", inputPhysType.generateComparator(group.collation()));
            Pair<Expression, Expression> partitionIterator = this.getPartitionIterator(builder, source_, inputPhysType, group, comparator_);
            Expression collectionExpr = (Expression)partitionIterator.left;
            Expression iterator_ = (Expression)partitionIterator.right;
            ArrayList<AggImpState> aggs = new ArrayList<AggImpState>();
            List<AggregateCall> aggregateCalls = group.getAggregateCalls(this);
            for (int aggIdx = 0; aggIdx < aggregateCalls.size(); ++aggIdx) {
                AggregateCall call = aggregateCalls.get(aggIdx);
                aggs.add(new AggImpState(aggIdx, call, true));
            }
            RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
            typeBuilder.addAll(inputPhysType.getRowType().getFieldList());
            for (AggImpState agg : aggs) {
                typeBuilder.add(agg.call.name, agg.call.type);
            }
            RelDataType outputRowType = typeBuilder.build();
            PhysType outputPhysType = PhysTypeImpl.of(typeFactory, outputRowType, pref.prefer(result.format));
            Expression list_ = builder.append("list", (Expression)Expressions.new_(ArrayList.class, (Expression[])new Expression[]{Expressions.call((Expression)collectionExpr, (Method)BuiltInMethod.COLLECTION_SIZE.method, (Expression[])new Expression[0])}), false);
            Pair<Expression, Expression> collationKey = this.getRowCollationKey(builder, inputPhysType, group, windowIdx);
            Expression keySelector = (Expression)collationKey.left;
            Expression keyComparator = (Expression)collationKey.right;
            BlockBuilder builder3 = new BlockBuilder();
            Expression rows_ = builder3.append("rows", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltInMethod.ITERATOR_NEXT.method, (Expression[])new Expression[0]), Object[].class), false);
            builder3.add(Expressions.statement((Expression)Expressions.assign((Expression)prevStart, (Expression)Expressions.constant((Object)-1))));
            builder3.add(Expressions.statement((Expression)Expressions.assign((Expression)prevEnd, (Expression)Expressions.constant((Object)Integer.MAX_VALUE))));
            BlockBuilder builder4 = new BlockBuilder();
            ParameterExpression i_ = Expressions.parameter(Integer.TYPE, (String)builder4.newName("i"));
            Expression row_ = builder4.append("row", RexToLixTranslator.convert((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)i_), inputPhysType.getJavaRowType()));
            WindowRelInputGetter inputGetter = new WindowRelInputGetter(row_, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
            RexToLixTranslator translator = RexToLixTranslator.forAggregation(typeFactory, builder4, inputGetter);
            ArrayList<Expression> outputRow = new ArrayList<Expression>();
            int fieldCountWithAggResults = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCountWithAggResults; ++i) {
                outputRow.add(inputPhysType.fieldReference(row_, i, outputPhysType.getJavaFieldType(i)));
            }
            this.declareAndResetState(typeFactory, builder, result, windowIdx, aggs, outputPhysType, outputRow);
            ConstantExpression minX = Expressions.constant((Object)0);
            Expression partitionRowCount = builder3.append("partRows", (Expression)Expressions.field((Expression)rows_, (String)"length"));
            Expression maxX = builder3.append("maxX", (Expression)Expressions.subtract((Expression)partitionRowCount, (Expression)Expressions.constant((Object)1)));
            Expression startUnchecked = builder4.append("start", this.translateBound(translator, i_, row_, (Expression)minX, maxX, rows_, group, true, inputPhysType, comparator_, keySelector, keyComparator));
            Expression endUnchecked = builder4.append("end", this.translateBound(translator, i_, row_, (Expression)minX, maxX, rows_, group, false, inputPhysType, comparator_, keySelector, keyComparator));
            if (group.isAlwaysNonEmpty()) {
                startX = startUnchecked;
                endX = endUnchecked;
                hasRows = Expressions.constant((Object)true);
            } else {
                Expression startTmp = group.lowerBound.isUnbounded() || startUnchecked == i_ ? startUnchecked : builder4.append("startTmp", (Expression)Expressions.call(null, (Method)BuiltInMethod.MATH_MAX.method, (Expression[])new Expression[]{startUnchecked, minX}));
                Expression endTmp = group.upperBound.isUnbounded() || endUnchecked == i_ ? endUnchecked : builder4.append("endTmp", (Expression)Expressions.call(null, (Method)BuiltInMethod.MATH_MIN.method, (Expression[])new Expression[]{endUnchecked, maxX}));
                ParameterExpression startPe = Expressions.parameter((int)0, Integer.TYPE, (String)builder4.newName("startChecked"));
                ParameterExpression endPe = Expressions.parameter((int)0, Integer.TYPE, (String)builder4.newName("endChecked"));
                builder4.add((Statement)Expressions.declare((int)16, (ParameterExpression)startPe, null));
                builder4.add((Statement)Expressions.declare((int)16, (ParameterExpression)endPe, null));
                hasRows = builder4.append("hasRows", (Expression)Expressions.lessThanOrEqual((Expression)startTmp, (Expression)endTmp));
                builder4.add((Statement)Expressions.ifThenElse((Expression)hasRows, (Node)Expressions.block((Statement[])new Statement[]{Expressions.statement((Expression)Expressions.assign((Expression)startPe, (Expression)startTmp)), Expressions.statement((Expression)Expressions.assign((Expression)endPe, (Expression)endTmp))}), (Node)Expressions.block((Statement[])new Statement[]{Expressions.statement((Expression)Expressions.assign((Expression)startPe, (Expression)Expressions.constant((Object)-1))), Expressions.statement((Expression)Expressions.assign((Expression)endPe, (Expression)Expressions.constant((Object)-1)))})));
                startX = startPe;
                endX = endPe;
            }
            BlockBuilder builder5 = new BlockBuilder(true, builder4);
            BinaryExpression rowCountWhenNonEmpty = Expressions.add((Expression)(startX == minX ? endX : Expressions.subtract((Expression)endX, (Expression)startX)), (Expression)Expressions.constant((Object)1));
            Expression frameRowCount = hasRows.equals((Object)Expressions.constant((Object)true)) ? builder4.append("totalRows", (Expression)rowCountWhenNonEmpty) : builder4.append("totalRows", Expressions.condition((Expression)hasRows, (Expression)rowCountWhenNonEmpty, (Expression)Expressions.constant((Object)0)));
            ParameterExpression actualStart = Expressions.parameter((int)0, Integer.TYPE, (String)builder5.newName("actualStart"));
            BlockBuilder builder6 = new BlockBuilder(true, builder5);
            builder6.add(Expressions.statement((Expression)Expressions.assign((Expression)actualStart, (Expression)startX)));
            for (AggImpState agg : aggs) {
                agg.implementor.implementReset(agg.context, new WinAggResetContextImpl(builder6, agg.state, (Expression)i_, startX, endX, (Expression)hasRows, partitionRowCount, frameRowCount));
            }
            BinaryExpression lowerBoundCanChange = group.lowerBound.isUnbounded() && group.lowerBound.isPreceding() ? Expressions.constant((Object)false) : Expressions.notEqual((Expression)startX, (Expression)prevStart);
            BinaryExpression needRecomputeWindow = Expressions.orElse((Expression)lowerBoundCanChange, (Expression)Expressions.lessThan((Expression)endX, (Expression)prevEnd));
            BlockStatement resetWindowState = builder6.toBlock();
            if (resetWindowState.statements.size() == 1) {
                builder5.add((Statement)Expressions.declare((int)0, (ParameterExpression)actualStart, (Expression)Expressions.condition((Expression)needRecomputeWindow, (Expression)startX, (Expression)Expressions.add((Expression)prevEnd, (Expression)Expressions.constant((Object)1)))));
            } else {
                builder5.add((Statement)Expressions.declare((int)0, (ParameterExpression)actualStart, null));
                builder5.add((Statement)Expressions.ifThenElse((Expression)needRecomputeWindow, (Node)resetWindowState, (Node)Expressions.statement((Expression)Expressions.assign((Expression)actualStart, (Expression)Expressions.add((Expression)prevEnd, (Expression)Expressions.constant((Object)1))))));
            }
            if (lowerBoundCanChange instanceof BinaryExpression) {
                builder5.add(Expressions.statement((Expression)Expressions.assign((Expression)prevStart, (Expression)startX)));
            }
            builder5.add(Expressions.statement((Expression)Expressions.assign((Expression)prevEnd, (Expression)endX)));
            BlockBuilder builder7 = new BlockBuilder(true, builder5);
            DeclarationStatement jDecl = Expressions.declare((int)0, (String)"j", (Expression)actualStart);
            PhysType inputPhysTypeFinal = inputPhysType;
            Function<BlockBuilder, WinAggFrameResultContext> resultContextBuilder = this.getBlockBuilderWinAggFrameResultContextFunction(typeFactory, result, translatedConstants, comparator_, rows_, i_, startX, endX, (Expression)minX, maxX, (Expression)hasRows, frameRowCount, partitionRowCount, jDecl, inputPhysTypeFinal);
            Function<AggImpState, List<RexNode>> rexArguments = new Function<AggImpState, List<RexNode>>(){

                @Override
                public List<RexNode> apply(AggImpState agg) {
                    List<Integer> argList = agg.call.getArgList();
                    List<RelDataType> inputTypes = EnumUtils.fieldRowTypes(result.physType.getRowType(), EnumerableWindow.this.constants, argList);
                    ArrayList<RexNode> args = new ArrayList<RexNode>(inputTypes.size());
                    for (int i = 0; i < argList.size(); ++i) {
                        Integer idx = argList.get(i);
                        args.add(new RexInputRef(idx, inputTypes.get(i)));
                    }
                    return args;
                }
            };
            this.implementAdd(aggs, builder7, resultContextBuilder, rexArguments, jDecl);
            BlockStatement forBlock = builder7.toBlock();
            if (!forBlock.statements.isEmpty()) {
                ForStatement forAggLoop = Expressions.for_(Arrays.asList(jDecl), (Expression)Expressions.lessThanOrEqual((Expression)jDecl.parameter, (Expression)endX), (Expression)Expressions.preIncrementAssign((Expression)jDecl.parameter), (Statement)forBlock);
                if (!hasRows.equals((Object)Expressions.constant((Object)true))) {
                    forAggLoop = Expressions.ifThen((Expression)hasRows, (Node)forAggLoop);
                }
                builder5.add((Statement)forAggLoop);
            }
            if (this.implementResult(aggs, builder5, resultContextBuilder, rexArguments, true)) {
                builder4.add((Statement)Expressions.ifThen((Expression)Expressions.orElse((Expression)lowerBoundCanChange, (Expression)Expressions.notEqual((Expression)endX, (Expression)prevEnd)), (Node)builder5.toBlock()));
            }
            this.implementResult(aggs, builder4, resultContextBuilder, rexArguments, false);
            builder4.add(Expressions.statement((Expression)Expressions.call((Expression)list_, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{outputPhysType.record(outputRow)})));
            builder3.add((Statement)Expressions.for_((DeclarationStatement)Expressions.declare((int)0, (ParameterExpression)i_, (Expression)Expressions.constant((Object)0)), (Expression)Expressions.lessThan((Expression)i_, (Expression)Expressions.field((Expression)rows_, (String)"length")), (Expression)Expressions.preIncrementAssign((Expression)i_), (Statement)builder4.toBlock()));
            builder.add((Statement)Expressions.while_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltInMethod.ITERATOR_HAS_NEXT.method, (Expression[])new Expression[0]), (Statement)builder3.toBlock()));
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)collectionExpr, (Method)BuiltInMethod.MAP_CLEAR.method, (Expression[])new Expression[0])));
            source_ = builder.append("source", (Expression)Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{list_}));
            inputPhysType = outputPhysType;
        }
        builder.add((Statement)Expressions.return_(null, (Expression)source_));
        return implementor.result(inputPhysType, builder.toBlock());
    }

    private Function<BlockBuilder, WinAggFrameResultContext> getBlockBuilderWinAggFrameResultContextFunction(final JavaTypeFactory typeFactory, final EnumerableRel.Result result, final List<Expression> translatedConstants, final Expression comparator_, final Expression rows_, final ParameterExpression i_, final Expression startX, final Expression endX, final Expression minX, final Expression maxX, final Expression hasRows, final Expression frameRowCount, final Expression partitionRowCount, final DeclarationStatement jDecl, final PhysType inputPhysType) {
        return new Function<BlockBuilder, WinAggFrameResultContext>(){

            @Override
            public WinAggFrameResultContext apply(final BlockBuilder block) {
                return new WinAggFrameResultContext(){

                    @Override
                    public RexToLixTranslator rowTranslator(Expression rowIndex) {
                        Expression row = this.getRow(rowIndex);
                        WindowRelInputGetter inputGetter = new WindowRelInputGetter(row, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
                        return RexToLixTranslator.forAggregation(typeFactory, block, inputGetter);
                    }

                    @Override
                    public Expression computeIndex(Expression offset, WinAggImplementor.SeekType seekType) {
                        ParameterExpression index;
                        if (seekType == WinAggImplementor.SeekType.AGG_INDEX) {
                            index = jDecl.parameter;
                        } else if (seekType == WinAggImplementor.SeekType.SET) {
                            index = i_;
                        } else if (seekType == WinAggImplementor.SeekType.START) {
                            index = startX;
                        } else if (seekType == WinAggImplementor.SeekType.END) {
                            index = endX;
                        } else {
                            throw new IllegalArgumentException("SeekSet " + (Object)((Object)seekType) + " is not supported");
                        }
                        if (!Expressions.constant((Object)0).equals((Object)offset)) {
                            index = block.append("idx", (Expression)Expressions.add((Expression)index, (Expression)offset));
                        }
                        return index;
                    }

                    private Expression checkBounds(Expression rowIndex, Expression minIndex, Expression maxIndex) {
                        if (rowIndex == i_ || rowIndex == startX || rowIndex == endX) {
                            return hasRows;
                        }
                        Expression res = block.append("rowInFrame", Expressions.foldAnd(ImmutableList.of(hasRows, Expressions.greaterThanOrEqual((Expression)rowIndex, (Expression)minIndex), Expressions.lessThanOrEqual((Expression)rowIndex, (Expression)maxIndex))));
                        return res;
                    }

                    @Override
                    public Expression rowInFrame(Expression rowIndex) {
                        return this.checkBounds(rowIndex, startX, endX);
                    }

                    @Override
                    public Expression rowInPartition(Expression rowIndex) {
                        return this.checkBounds(rowIndex, minX, maxX);
                    }

                    @Override
                    public Expression compareRows(Expression a, Expression b) {
                        return Expressions.call((Expression)comparator_, (Method)BuiltInMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{this.getRow(a), this.getRow(b)});
                    }

                    public Expression getRow(Expression rowIndex) {
                        return block.append("jRow", RexToLixTranslator.convert((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)rowIndex), inputPhysType.getJavaRowType()));
                    }

                    @Override
                    public Expression index() {
                        return i_;
                    }

                    @Override
                    public Expression startIndex() {
                        return startX;
                    }

                    @Override
                    public Expression endIndex() {
                        return endX;
                    }

                    @Override
                    public Expression hasRows() {
                        return hasRows;
                    }

                    @Override
                    public Expression getFrameRowCount() {
                        return frameRowCount;
                    }

                    @Override
                    public Expression getPartitionRowCount() {
                        return partitionRowCount;
                    }
                };
            }
        };
    }

    private Pair<Expression, Expression> getPartitionIterator(BlockBuilder builder, Expression source_, PhysType inputPhysType, Window.Group group, Expression comparator_) {
        if (group.keys.isEmpty()) {
            Expression tempList_ = builder.append("tempList", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)source_, (Method)BuiltInMethod.INTO.method, (Expression[])new Expression[]{Expressions.new_(ArrayList.class)}), List.class));
            return Pair.of(tempList_, builder.append("iterator", (Expression)Expressions.call(null, (Method)BuiltInMethod.SORTED_MULTI_MAP_SINGLETON.method, (Expression[])new Expression[]{comparator_, tempList_})));
        }
        Expression multiMap_ = builder.append("multiMap", (Expression)Expressions.new_(SortedMultiMap.class));
        BlockBuilder builder2 = new BlockBuilder();
        ParameterExpression v_ = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)builder2.newName("v"));
        DeclarationStatement declare = Expressions.declare((int)0, (String)"key", (Expression)inputPhysType.selector(v_, group.keys.toList(), JavaRowFormat.CUSTOM));
        builder2.add((Statement)declare);
        ParameterExpression key_ = declare.parameter;
        builder2.add(Expressions.statement((Expression)Expressions.call((Expression)multiMap_, (Method)BuiltInMethod.SORTED_MULTI_MAP_PUT_MULTI.method, (Expression[])new Expression[]{key_, v_})));
        builder2.add((Statement)Expressions.return_(null, (Expression)Expressions.constant(null)));
        builder.add(Expressions.statement((Expression)Expressions.call((Expression)source_, (Method)BuiltInMethod.ENUMERABLE_FOREACH.method, (Expression[])new Expression[]{Expressions.lambda((BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{v_})})));
        return Pair.of(multiMap_, builder.append("iterator", (Expression)Expressions.call((Expression)multiMap_, (Method)BuiltInMethod.SORTED_MULTI_MAP_ARRAYS.method, (Expression[])new Expression[]{comparator_})));
    }

    private Pair<Expression, Expression> getRowCollationKey(BlockBuilder builder, PhysType inputPhysType, Window.Group group, int windowIdx) {
        if (!(group.isRows || group.upperBound.isUnbounded() && group.lowerBound.isUnbounded())) {
            Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(group.collation().getFieldCollations());
            return Pair.of(builder.append("keySelector" + windowIdx, (Expression)pair.left, false), builder.append("keyComparator" + windowIdx, (Expression)pair.right, false));
        }
        return Pair.of(null, null);
    }

    private void declareAndResetState(final JavaTypeFactory typeFactory, BlockBuilder builder, final EnumerableRel.Result result, int windowIdx, List<AggImpState> aggs, PhysType outputPhysType, List<Expression> outputRow) {
        for (final AggImpState agg : aggs) {
            ParameterExpression aggRes;
            agg.context = new WinAggContext(){

                @Override
                public SqlAggFunction aggregation() {
                    return agg.call.getAggregation();
                }

                @Override
                public RelDataType returnRelType() {
                    return agg.call.type;
                }

                @Override
                public Type returnType() {
                    return EnumUtils.javaClass(typeFactory, this.returnRelType());
                }

                @Override
                public List<? extends Type> parameterTypes() {
                    return EnumUtils.fieldTypes(typeFactory, this.parameterRelTypes());
                }

                @Override
                public List<? extends RelDataType> parameterRelTypes() {
                    return EnumUtils.fieldRowTypes(result.physType.getRowType(), EnumerableWindow.this.constants, agg.call.getArgList());
                }
            };
            String aggName = "a" + agg.aggIdx;
            if (CalcitePrepareImpl.DEBUG) {
                aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
            }
            List<Type> state = agg.implementor.getStateType(agg.context);
            ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
            for (int i = 0; i < state.size(); ++i) {
                Type type = state.get(i);
                ParameterExpression pe = Expressions.parameter((Type)type, (String)builder.newName(aggName + "s" + i + "w" + windowIdx));
                builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, null));
                decls.add((Expression)pe);
            }
            agg.state = decls;
            Type aggHolderType = agg.context.returnType();
            Type aggStorageType = outputPhysType.getJavaFieldType(outputRow.size());
            if (Primitive.is((Type)aggHolderType) && !Primitive.is((Type)aggStorageType)) {
                aggHolderType = Primitive.box((Type)aggHolderType);
            }
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)aggRes, (Expression)Expressions.constant((Object)(Primitive.is((Type)(aggRes = Expressions.parameter((int)0, (Type)aggHolderType, (String)builder.newName(aggName + "w" + windowIdx))).getType()) ? Primitive.of((Type)aggRes.getType()).defaultValue : null), (Type)aggRes.getType())));
            agg.result = aggRes;
            outputRow.add((Expression)aggRes);
            agg.implementor.implementReset(agg.context, new WinAggResetContextImpl(builder, agg.state, null, null, null, null, null, null));
        }
    }

    private void implementAdd(List<AggImpState> aggs, BlockBuilder builder7, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, final DeclarationStatement jDecl) {
        for (final AggImpState agg : aggs) {
            WinAggAddContextImpl addContext = new WinAggAddContextImpl(builder7, agg.state, frame){

                @Override
                public Expression currentPosition() {
                    return jDecl.parameter;
                }

                @Override
                public List<RexNode> rexArguments() {
                    return (List)rexArguments.apply(agg);
                }

                @Override
                public RexNode rexFilterArgument() {
                    return null;
                }
            };
            agg.implementor.implementAdd(agg.context, addContext);
        }
    }

    private boolean implementResult(List<AggImpState> aggs, BlockBuilder builder, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, boolean cachedBlock) {
        boolean nonEmpty = false;
        for (final AggImpState agg : aggs) {
            boolean needCache = true;
            if (agg.implementor instanceof WinAggImplementor) {
                WinAggImplementor imp = (WinAggImplementor)agg.implementor;
                needCache = imp.needCacheWhenFrameIntact();
            }
            if (needCache ^ cachedBlock) continue;
            nonEmpty = true;
            Expression res = agg.implementor.implementResult(agg.context, new WinAggResultContextImpl(builder, agg.state, frame){

                @Override
                public List<RexNode> rexArguments() {
                    return (List)rexArguments.apply(agg);
                }
            });
            Expression aggRes = builder.append("a" + agg.aggIdx + "res", RexToLixTranslator.convert(res, agg.result.getType()));
            builder.add(Expressions.statement((Expression)Expressions.assign((Expression)agg.result, (Expression)aggRes)));
        }
        return nonEmpty;
    }

    private Expression translateBound(RexToLixTranslator translator, ParameterExpression i_, Expression row_, Expression min_, Expression max_, Expression rows_, Window.Group group, boolean lower, PhysType physType, Expression rowComparator, Expression keySelector, Expression keyComparator) {
        RexWindowBound bound;
        RexWindowBound rexWindowBound = bound = lower ? group.lowerBound : group.upperBound;
        if (bound.isUnbounded()) {
            return bound.isPreceding() ? min_ : max_;
        }
        if (group.isRows) {
            if (bound.isCurrentRow()) {
                return i_;
            }
            RexNode node = bound.getOffset();
            Expression offs = translator.translate(node);
            offs = RexToLixTranslator.convert(offs, Integer.TYPE);
            ParameterExpression b = i_;
            b = bound.isFollowing() ? Expressions.add((Expression)b, (Expression)offs) : Expressions.subtract((Expression)b, (Expression)offs);
            return b;
        }
        Expression searchLower = min_;
        Expression searchUpper = max_;
        if (bound.isCurrentRow()) {
            if (lower) {
                searchUpper = i_;
            } else {
                searchLower = i_;
            }
        }
        List<RelFieldCollation> fieldCollations = group.collation().getFieldCollations();
        if (bound.isCurrentRow() && fieldCollations.size() != 1) {
            return Expressions.call((Method)(lower ? BuiltInMethod.BINARY_SEARCH5_LOWER : BuiltInMethod.BINARY_SEARCH5_UPPER).method, (Expression[])new Expression[]{rows_, row_, searchLower, searchUpper, keySelector, keyComparator});
        }
        assert (fieldCollations.size() == 1) : "When using range window specification, ORDER BY should have exactly one expression. Actual collation is " + group.collation();
        int orderKey = fieldCollations.get(0).getFieldIndex();
        RelDataType keyType = physType.getRowType().getFieldList().get(orderKey).getType();
        Type desiredKeyType = translator.typeFactory.getJavaClass(keyType);
        if (bound.getOffset() == null) {
            desiredKeyType = Primitive.box((Type)desiredKeyType);
        }
        Expression val = translator.translate((RexNode)new RexInputRef(orderKey, keyType), desiredKeyType);
        if (!bound.isCurrentRow()) {
            RexNode node = bound.getOffset();
            Expression offs = translator.translate(node);
            val = bound.isFollowing() ? Expressions.add((Expression)val, (Expression)offs) : Expressions.subtract((Expression)val, (Expression)offs);
        }
        return Expressions.call((Method)(lower ? BuiltInMethod.BINARY_SEARCH6_LOWER : BuiltInMethod.BINARY_SEARCH6_UPPER).method, (Expression[])new Expression[]{rows_, val, searchLower, searchUpper, keySelector, keyComparator});
    }

    private static class WindowRelInputGetter
    implements RexToLixTranslator.InputGetter {
        private final Expression row;
        private final PhysType rowPhysType;
        private final int actualInputFieldCount;
        private final List<Expression> constants;

        private WindowRelInputGetter(Expression row, PhysType rowPhysType, int actualInputFieldCount, List<Expression> constants) {
            this.row = row;
            this.rowPhysType = rowPhysType;
            this.actualInputFieldCount = actualInputFieldCount;
            this.constants = constants;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            if (index < this.actualInputFieldCount) {
                Expression current = list.append("current", this.row);
                return this.rowPhysType.fieldReference(current, index, storageType);
            }
            return this.constants.get(index - this.actualInputFieldCount);
        }
    }
}

