/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumUtils;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelNodes;
import hive.org.apache.calcite.rel.core.EquiJoin;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Method;
import java.util.Set;

public class EnumerableJoin
extends EquiJoin
implements EnumerableRel {
    protected EnumerableJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, joinType, variablesStopped);
    }

    public static EnumerableJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE);
        return new EnumerableJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys, joinType, variablesStopped);
    }

    @Override
    public EnumerableJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        try {
            return new EnumerableJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, joinType, this.variablesStopped);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        switch (this.joinType) {
            case RIGHT: {
                rowCount = this.addEpsilon(rowCount);
                break;
            }
            default: {
                if (RelNodes.COMPARATOR.compare(this.left, this.right) <= 0) break;
                rowCount = this.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.getRows();
        double leftRowCount = this.left.getRows();
        rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
        rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    private double addEpsilon(double d) {
        assert (d >= 0.0);
        double d0 = d;
        if (d < 10.0 && (d *= 1.001) != d0) {
            return d;
        }
        if ((d += 1.0) != d0) {
            return d;
        }
        return d *= 1.001;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        PhysType keyPhysType = leftResult.physType.project(this.leftKeys, JavaRowFormat.LIST);
        return implementor.result(physType, builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltInMethod.JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys), EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType))}).append((Object)Util.first(keyPhysType.comparer(), Expressions.constant(null))).append((Object)Expressions.constant((Object)this.joinType.generatesNullsOnLeft())).append((Object)Expressions.constant((Object)this.joinType.generatesNullsOnRight())))).toBlock());
    }
}

