/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Type;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Visitor;

public class TypeBinaryExpression
extends Expression {
    public final Expression expression;
    public final Type type;

    public TypeBinaryExpression(ExpressionType nodeType, Expression expression, Type type) {
        super(nodeType, Boolean.TYPE);
        assert (expression != null) : "expression should not be null";
        this.expression = expression;
        this.type = type;
    }

    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression expression = this.expression.accept(visitor);
        return visitor.visit(this, expression);
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        writer.append(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeBinaryExpression that = (TypeBinaryExpression)o;
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

