/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexExpression
extends Expression {
    public final Expression array;
    public final List<Expression> indexExpressions;

    public IndexExpression(Expression array, List<Expression> indexExpressions) {
        super(ExpressionType.ArrayIndex, Types.getComponentType(array.getType()));
        assert (array != null) : "array should not be null";
        assert (indexExpressions != null) : "indexExpressions should not be null";
        assert (!indexExpressions.isEmpty()) : "indexExpressions should not be empty";
        this.array = array;
        this.indexExpressions = indexExpressions;
    }

    @Override
    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression array = this.array.accept(visitor);
        List<Expression> indexExpressions = Expressions.acceptExpressions(this.indexExpressions, visitor);
        return visitor.visit(this, array, indexExpressions);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        this.array.accept(writer, lprec, this.nodeType.lprec);
        writer.list("[", ", ", "]", this.indexExpressions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexExpression that = (IndexExpression)o;
        if (!this.array.equals(that.array)) {
            return false;
        }
        return this.indexExpressions.equals(that.indexExpressions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.array.hashCode();
        result = 31 * result + this.indexExpressions.hashCode();
        return result;
    }
}

