/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class ParquetWriter<T>
implements Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 0x8000000;
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final CompressionCodecName DEFAULT_COMPRESSION_CODEC_NAME = CompressionCodecName.UNCOMPRESSED;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.WriterVersion.PARQUET_1_0;
    public static final int MAX_PADDING_SIZE_DEFAULT = 0;
    private final InternalParquetRecordWriter<T> writer;

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, true, false);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, validating);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, DEFAULT_WRITER_VERSION);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, new Configuration());
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(file, ParquetFileWriter.Mode.CREATE, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, conf);
    }

    @Deprecated
    public ParquetWriter(Path file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(file, mode, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, conf, 0);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000);
    }

    @Deprecated
    public ParquetWriter(Path file, Configuration conf, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000, 0x100000, true, false, DEFAULT_WRITER_VERSION, conf);
    }

    ParquetWriter(Path file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf, int maxPaddingSize) throws IOException {
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        MessageType schema = writeContext.getSchema();
        ParquetFileWriter fileWriter = new ParquetFileWriter(conf, schema, file, mode, blockSize, maxPaddingSize);
        fileWriter.start();
        CodecFactory codecFactory = new CodecFactory(conf, pageSize);
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(compressionCodecName);
        this.writer = new InternalParquetRecordWriter<T>(fileWriter, writeSupport, schema, writeContext.getExtraMetaData(), blockSize, pageSize, compressor, dictionaryPageSize, enableDictionary, validating, writerVersion, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public void write(T object) throws IOException {
        try {
            this.writer.write(object);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public long getDataSize() {
        return this.writer.getDataSize();
    }

    public static abstract class Builder<T, SELF extends Builder<T, SELF>> {
        private final Path file;
        private Configuration conf = new Configuration();
        private ParquetFileWriter.Mode mode;
        private CompressionCodecName codecName = DEFAULT_COMPRESSION_CODEC_NAME;
        private int rowGroupSize = 0x8000000;
        private int pageSize = 0x100000;
        private int dictionaryPageSize = 0x100000;
        private int maxPaddingSize = 0;
        private boolean enableDictionary = true;
        private boolean enableValidation = false;
        private ParquetProperties.WriterVersion writerVersion = DEFAULT_WRITER_VERSION;

        protected Builder(Path file) {
            this.file = file;
        }

        protected abstract SELF self();

        protected abstract WriteSupport<T> getWriteSupport(Configuration var1);

        public SELF withConf(Configuration conf) {
            this.conf = conf;
            return this.self();
        }

        public SELF withWriteMode(ParquetFileWriter.Mode mode) {
            this.mode = mode;
            return this.self();
        }

        public SELF withCompressionCodec(CompressionCodecName codecName) {
            this.codecName = codecName;
            return this.self();
        }

        public SELF withRowGroupSize(int rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this.self();
        }

        public SELF withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this.self();
        }

        public SELF withDictionaryPageSize(int dictionaryPageSize) {
            this.dictionaryPageSize = dictionaryPageSize;
            return this.self();
        }

        public SELF withMaxPaddingSize(int maxPaddingSize) {
            this.maxPaddingSize = maxPaddingSize;
            return this.self();
        }

        public SELF enableDictionaryEncoding() {
            this.enableDictionary = true;
            return this.self();
        }

        public SELF withDictionaryEncoding(boolean enableDictionary) {
            this.enableDictionary = enableDictionary;
            return this.self();
        }

        public SELF enableValidation() {
            this.enableValidation = true;
            return this.self();
        }

        public SELF withValidation(boolean enableValidation) {
            this.enableValidation = enableValidation;
            return this.self();
        }

        public SELF withWriterVersion(ParquetProperties.WriterVersion version) {
            this.writerVersion = version;
            return this.self();
        }

        public ParquetWriter<T> build() throws IOException {
            return new ParquetWriter<T>(this.file, this.mode, this.getWriteSupport(this.conf), this.codecName, this.rowGroupSize, this.pageSize, this.dictionaryPageSize, this.enableDictionary, this.enableValidation, this.writerVersion, this.conf, this.maxPaddingSize);
        }
    }
}

