/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.BulkLoadRecordWriter;
import com.mapr.fs.hbase.TableUtil;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CopyTable
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyTable.class);
    static final String NAME = "CopyTable";
    String srcPath;
    String dstPath;
    Configuration conf;
    HTable srcTable;
    boolean failed = false;
    int numThreads = 16;
    boolean useMapReduce = true;
    boolean useBulkLoad = true;
    String columnSpec;
    int maxVersions = Integer.MAX_VALUE;
    long startTime = 0L;
    long endTime = Long.MAX_VALUE;
    static boolean isSuccess = false;

    protected void setScanColumns(Scan scan) {
        if (this.columnSpec != null) {
            String[] cols;
            for (String col : cols = this.columnSpec.split(",")) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    scan.addColumn(Bytes.toBytes((String)names[0]), Bytes.toBytes((String)names[1]));
                    continue;
                }
                scan.addFamily(Bytes.toBytes((String)col));
            }
        }
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: CopyTable [Options] -src <source table path> -dst <destination table path>\nOptions:\n[-columns cf1[:col1],...] [-maxversions <max number of versions to copy>]\n[-starttime <time>]\n[-endtime <time>]\n[-mapreduce <true|false> (default: true)]\n[-bulkload <true|false> (default: true)]\n[-numthreads <numThreads> (default:" + this.numThreads + ", valid only when -mapreduce is false)]\n");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                this.columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxversions")) {
                this.maxVersions = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-starttime")) {
                String startTimeStr;
                this.startTime = (startTimeStr = args[++i]).equals("-INF") ? 0L : Long.parseLong(startTimeStr);
                continue;
            }
            if (args[i].equalsIgnoreCase("-endtime")) {
                String endTimeStr;
                this.endTime = (endTimeStr = args[++i]).equals("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                this.useMapReduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-bulkload")) {
                this.useBulkLoad = Boolean.valueOf(args[++i]);
                continue;
            }
            this.Usage(null);
        }
        if (this.srcPath == null || this.dstPath == null) {
            this.Usage("missing -src or -dst.");
        }
        if (this.startTime > this.endTime) {
            this.Usage("endtime is smaller than starttime.");
        }
    }

    public int run(String[] args) throws Exception {
        this.ParseArgs(args);
        if (this.useMapReduce) {
            return this.run_MR();
        }
        return this.run_NoMR();
    }

    public int run_MR() throws Exception {
        int ret;
        Job job = new Job(this.getConf(), "CopyTable_" + this.dstPath);
        Configuration conf = job.getConfiguration();
        job.setJarByClass(CopyTable.class);
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        if (!hbaseAdmin.tableExists(this.dstPath)) {
            List<String> cfList = TableUtil.getColumnFamiliesList(this.columnSpec);
            try {
                TableUtil.createTableForCopy(conf, this.srcPath, this.dstPath, cfList, this.useBulkLoad);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while creating table for running copytable: " + e));
                throw new Exception(e.getMessage());
            }
        }
        hbaseAdmin.close();
        Scan scan = new Scan();
        scan.setMaxVersions();
        this.setScanColumns(scan);
        scan.setMaxVersions(this.maxVersions);
        scan.setTimeRange(this.startTime, this.endTime);
        if (this.useBulkLoad) {
            TableMapReduceUtil.initTableMapperJob((String)this.srcPath, (Scan)scan, CopyTableMapper.class, ImmutableBytesWritable.class, KeyValue.class, (Job)job);
        } else {
            TableMapReduceUtil.initTableMapperJob((String)this.srcPath, (Scan)scan, Import.Importer.class, ImmutableBytesWritable.class, Mutation.class, (Job)job);
        }
        LOG.info((Object)("Looking up current regions for table " + this.srcPath));
        HTable srcTable = new HTable(conf, this.srcPath);
        List<ImmutableBytesWritable> startKeys = CopyTable.getRegionStartKeys(srcTable);
        String uuid = UUID.randomUUID().toString();
        job.setNumReduceTasks(0);
        Path outputPath = new Path(conf.get("hadoop.tmp.dir"), "output_" + uuid);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        if (this.useBulkLoad) {
            job.setOutputFormatClass(HFileOutputFormat2.class);
            HFileOutputFormat2.configureMapRTablePath((Job)job, (String)this.dstPath);
        } else {
            job.setOutputFormatClass(TableOutputFormat.class);
            conf.set("hbase.mapred.outputtable", this.dstPath);
            conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        }
        job.submit();
        System.out.println("job_id: " + job.getJobID().toString());
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (this.useBulkLoad) {
            TableUtil.clearBulkLoad(conf, this.dstPath);
        }
        if (ret == 0) {
            FileSystem fs = outputPath.getFileSystem(conf);
            fs.delete(outputPath);
        }
        return ret;
    }

    public int run_NoMR() throws Exception {
        this.conf = this.getConf();
        this.conf.set("fs.default.name", "maprfs:///");
        this.conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        this.conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        this.srcTable = new HTable(this.conf, this.srcPath.getBytes());
        HTableDescriptor htd = this.srcTable.getTableDescriptor();
        byte[] uuid = htd.getValue(Bytes.toBytes((String)"UUID"));
        String uuidAsString = Bytes.toStringBinary((byte[])uuid);
        this.conf.set("maprdb.bulkload.uuid", uuidAsString);
        byte[][] startKeys = this.srcTable.getStartKeys();
        byte[][] endKeys = this.srcTable.getEndKeys();
        int numSplits = startKeys.length;
        HBaseAdmin hbaseAdmin = new HBaseAdmin(this.conf);
        if (!hbaseAdmin.tableExists(this.dstPath)) {
            List<String> cfList = TableUtil.getColumnFamiliesList(this.columnSpec);
            try {
                TableUtil.createTableForCopy(this.conf, this.srcPath, this.dstPath, cfList, this.useBulkLoad);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while creating table for running copytable: " + e));
                throw new Exception(e.getMessage());
            }
        }
        hbaseAdmin.close();
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new LoaderThread(i, startKeys[i], endKeys[i]));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (this.failed) {
            return 1;
        }
        long te = System.currentTimeMillis();
        System.out.println("CopyTable completed in " + (te - ts) + " ms");
        TableUtil.clearBulkLoad(this.conf, this.dstPath);
        return 0;
    }

    public static boolean copy(final String[] args, String user) throws Exception {
        boolean mapreduce = true;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-mapreduce")) continue;
            mapreduce = Boolean.valueOf(args[++i]);
        }
        UserGroupInformation ugi = CopyTable.createUser(user);
        LOG.info((Object)("Running copytable job " + mapreduce + " as user: " + user));
        if (!mapreduce) {
            System.out.println("No map-reduce");
        }
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
                    if (status == 0) {
                        CopyTable.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while running copytable job: " + e));
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public static void clearBulkLoad(String tableName) throws Exception {
        try {
            TableUtil.clearBulkLoad(new Configuration(), tableName);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while finishing copytable job: " + e));
            throw new Exception(e.getMessage());
        }
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    static class CopyTableMapper
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        CopyTableMapper() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                for (KeyValue kv : value.raw()) {
                    context.write((Object)row, (Object)kv);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class LoaderThread
    extends BaseLoaderThread {
        LoaderThread(int id, byte[] s, byte[] e) {
            super(id, s, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkLoadRecordWriter writer = null;
            try (ResultScanner scanner = null;){
                HTable st = new HTable(CopyTable.this.conf, CopyTable.this.srcPath);
                Scan scan = new Scan(this.startKey, this.endKey);
                CopyTable.this.setScanColumns(scan);
                scan.setMaxVersions(CopyTable.this.maxVersions);
                scan.setTimeRange(CopyTable.this.startTime, CopyTable.this.endTime);
                scanner = st.getScanner(scan);
                if (CopyTable.this.useBulkLoad) {
                    writer = new BulkLoadRecordWriter(CopyTable.this.conf, new Path(CopyTable.this.dstPath));
                    Result r = scanner.next();
                    while (r != null) {
                        KeyValue[] kvList;
                        for (KeyValue kv : kvList = r.raw()) {
                            writer.write(null, kv);
                        }
                        r = scanner.next();
                    }
                    if (writer != null) {
                        writer.close(null);
                    }
                } else {
                    HTable dstTable = new HTable(CopyTable.this.conf, CopyTable.this.dstPath);
                    dstTable.setAutoFlush(false);
                    Result r = scanner.next();
                    while (r != null) {
                        byte[] row = r.getRow();
                        Cell[] cells = r.rawCells();
                        Put p = new Put(row);
                        for (Cell c : cells) {
                            p.add(c);
                        }
                        dstTable.put(p);
                        r = scanner.next();
                    }
                    dstTable.close();
                }
            }
        }
    }

    abstract class BaseLoaderThread
    implements Runnable {
        protected byte[] startKey;
        protected byte[] endKey;
        protected int myid;

        protected BaseLoaderThread(int id, byte[] s, byte[] e) {
            this.myid = id;
            this.startKey = s;
            this.endKey = e;
        }
    }
}

