/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;

@InterfaceStability.Evolving
public class ThreadUtil {
    private static final Log LOG = LogFactory.getLog(ThreadUtil.class);

    public static void sleepAtLeastIgnoreInterrupts(long millis) {
        long start = Time.now();
        while (Time.now() - start < millis) {
            long timeToSleep = millis - (Time.now() - start);
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"interrupted while sleeping", (Throwable)ie);
            }
        }
    }
}

