/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.DigestAuthMethod;
import org.apache.hadoop.security.rpcauth.FakeKerberosAuthMethod;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.SimpleAuthMethod;

public class RpcAuthRegistry {
    private static final Log LOG = LogFactory.getLog(RpcAuthRegistry.class);
    private static final Map<Byte, RpcAuthMethod> authMethods = new LinkedHashMap<Byte, RpcAuthMethod>();
    private static final Map<String, RpcAuthMethod> loginModuleMap = new LinkedHashMap<String, RpcAuthMethod>();
    public static final RpcAuthMethod KERBEROS = KerberosAuthMethod.INSTANCE;
    public static final RpcAuthMethod FAKE_KERBEROS = FakeKerberosAuthMethod.INSTANCE;
    public static final RpcAuthMethod SIMPLE = SimpleAuthMethod.INSTANCE;
    public static final RpcAuthMethod DIGEST = DigestAuthMethod.INSTANCE;

    public static synchronized void addRpcAuthMethod(RpcAuthMethod authMethod) {
        RpcAuthMethod oldMethod;
        if (authMethods.containsKey(authMethod.authcode) && !(oldMethod = authMethods.get(authMethod.authcode)).getClass().equals(authMethod.getClass())) {
            throw new IllegalArgumentException(String.format("Duplicate authcode [%d] for '%s'. Already registerd for '%s'.", authMethod.authcode, authMethod.getClass().getCanonicalName(), oldMethod.getClass().getCanonicalName()));
        }
        for (String module : authMethod.loginModules()) {
            RpcAuthMethod oldMethod2;
            if (loginModuleMap.containsKey(module) && !(oldMethod2 = loginModuleMap.get(module)).getClass().equals(authMethod.getClass())) {
                throw new IllegalArgumentException(String.format("Duplicate login module [%s] for '%s'. Already registerd for '%s'.", module, authMethod.getClass().getCanonicalName(), oldMethod2.getClass().getCanonicalName()));
            }
            loginModuleMap.put(module, authMethod);
        }
        authMethods.put(authMethod.authcode, authMethod);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added " + authMethod + " to registry."));
        }
    }

    public static RpcAuthMethod getAuthMethodForLoginModule(String loginModule) {
        return loginModuleMap.get(loginModule);
    }

    public static RpcAuthMethod getAuthMethod(byte authCode) {
        return authMethods.get(authCode);
    }

    public static RpcAuthMethod getAuthMethod(String name) {
        for (RpcAuthMethod method : authMethods.values()) {
            if (!method.simpleName.equalsIgnoreCase(name)) continue;
            return method;
        }
        LOG.warn((Object)("No RpcAuthMethod registerd for name " + name));
        return null;
    }

    public static RpcAuthMethod getAuthMethod(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        for (RpcAuthMethod method : authMethods.values()) {
            if (!method.authenticationMethod.equals((Object)authenticationMethod)) continue;
            return method;
        }
        LOG.warn((Object)("No RpcAuthMethod registerd for authentication method " + (Object)((Object)authenticationMethod)));
        return null;
    }

    @Deprecated
    public static RpcAuthMethod readAuthMethod(DataInput in) throws IOException {
        byte code = in.readByte();
        if (!authMethods.containsKey(code)) {
            LOG.warn((Object)("No RpcAuthMethod registerd for auth code " + code));
        }
        return authMethods.get(code);
    }

    @Deprecated
    public static List<RpcAuthMethod> getAuthMethodList(byte[] authCodes) {
        ArrayList<RpcAuthMethod> list = new ArrayList<RpcAuthMethod>();
        for (byte code : authCodes) {
            RpcAuthMethod method = authMethods.get(code);
            if (method == null) {
                String name = "UNKNOWN(" + code + ")";
                method = new RpcAuthMethod(code, name, name, null){};
            }
            list.add(method);
        }
        return list;
    }

    static {
        RpcAuthRegistry.addRpcAuthMethod(SIMPLE);
        RpcAuthRegistry.addRpcAuthMethod(KERBEROS);
        RpcAuthRegistry.addRpcAuthMethod(DIGEST);
        RpcAuthRegistry.addRpcAuthMethod(FAKE_KERBEROS);
    }
}

