/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.ganglia;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.commons.configuration.SubsetConfiguration;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.sink.ganglia.AbstractGangliaSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaConf;
import org.apache.hadoop.metrics2.util.MetricsCache;

public class GangliaSink30
extends AbstractGangliaSink {
    public final Log LOG = LogFactory.getLog(this.getClass());
    private static final String TAGS_FOR_PREFIX_PROPERTY_PREFIX = "tagsForPrefix.";
    private MetricsCache metricsCache = new MetricsCache();
    private Map<String, Set<String>> useTagsMap = new HashMap<String, Set<String>>();

    @Override
    public void init(SubsetConfiguration conf) {
        super.init(conf);
        conf.setListDelimiter(',');
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (!propertyName.startsWith(TAGS_FOR_PREFIX_PROPERTY_PREFIX)) continue;
            String contextName = propertyName.substring(TAGS_FOR_PREFIX_PROPERTY_PREFIX.length());
            String[] tags = conf.getStringArray(propertyName);
            boolean useAllTags = false;
            HashSet<String> set = null;
            if (tags.length > 0) {
                set = new HashSet<String>();
                for (String tag : tags) {
                    tag = tag.trim();
                    useAllTags |= tag.equals("*");
                    if (tag.length() <= 0) continue;
                    set.add(tag);
                }
                if (useAllTags) {
                    set = null;
                }
            }
            this.useTagsMap.put(contextName, set);
        }
    }

    @InterfaceAudience.Private
    public void appendPrefix(MetricsRecord record, StringBuilder sb) {
        String contextName = record.context();
        Collection<MetricsTag> tags = record.tags();
        if (this.useTagsMap.containsKey(contextName)) {
            Set<String> useTags = this.useTagsMap.get(contextName);
            for (MetricsTag t : tags) {
                if (useTags != null && !useTags.contains(t.name()) || t.info() == MsInfo.Context || t.info() == MsInfo.Hostname || t.value() == null) continue;
                sb.append('.').append(t.name()).append('=').append(t.value());
            }
        }
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        try {
            String recordName = record.name();
            String contextName = record.context();
            StringBuilder sb = new StringBuilder();
            sb.append(contextName);
            sb.append('.');
            sb.append(recordName);
            this.appendPrefix(record, sb);
            String groupName = sb.toString();
            sb.append('.');
            int sbBaseLen = sb.length();
            String type = null;
            AbstractGangliaSink.GangliaSlope slopeFromMetric = null;
            AbstractGangliaSink.GangliaSlope calculatedSlope = null;
            MetricsCache.Record cachedMetrics = null;
            this.resetBuffer();
            if (!this.isSupportSparseMetrics()) {
                cachedMetrics = this.metricsCache.update(record);
                if (cachedMetrics != null && cachedMetrics.metricsEntrySet() != null) {
                    for (Map.Entry<String, AbstractMetric> entry : cachedMetrics.metricsEntrySet()) {
                        AbstractMetric metric = entry.getValue();
                        sb.append(metric.name());
                        String name = sb.toString();
                        metric.visit(this.gangliaMetricVisitor);
                        type = this.gangliaMetricVisitor.getType();
                        slopeFromMetric = this.gangliaMetricVisitor.getSlope();
                        GangliaConf gConf = this.getGangliaConfForMetric(name);
                        calculatedSlope = this.calculateSlope(gConf, slopeFromMetric);
                        this.emitMetric(groupName, name, type, metric.value().toString(), gConf, calculatedSlope);
                        sb.setLength(sbBaseLen);
                    }
                }
            } else {
                Collection metrics = (Collection)record.metrics();
                if (metrics.size() > 0) {
                    for (AbstractMetric metric : record.metrics()) {
                        sb.append(metric.name());
                        String name = sb.toString();
                        metric.visit(this.gangliaMetricVisitor);
                        type = this.gangliaMetricVisitor.getType();
                        slopeFromMetric = this.gangliaMetricVisitor.getSlope();
                        GangliaConf gConf = this.getGangliaConfForMetric(name);
                        calculatedSlope = this.calculateSlope(gConf, slopeFromMetric);
                        this.emitMetric(groupName, name, type, metric.value().toString(), gConf, calculatedSlope);
                        sb.setLength(sbBaseLen);
                    }
                }
            }
        }
        catch (IOException io) {
            throw new MetricsException("Failed to putMetrics", io);
        }
    }

    private AbstractGangliaSink.GangliaSlope calculateSlope(GangliaConf gConf, AbstractGangliaSink.GangliaSlope slopeFromMetric) {
        if (gConf.getSlope() != null) {
            return gConf.getSlope();
        }
        if (slopeFromMetric != null) {
            return slopeFromMetric;
        }
        return DEFAULT_SLOPE;
    }

    protected void emitMetric(String groupName, String name, String type, String value, GangliaConf gConf, AbstractGangliaSink.GangliaSlope gSlope) throws IOException {
        if (name == null) {
            this.LOG.warn((Object)"Metric was emitted with no name.");
            return;
        }
        if (value == null) {
            this.LOG.warn((Object)("Metric name " + name + " was emitted with a null value."));
            return;
        }
        if (type == null) {
            this.LOG.warn((Object)("Metric name " + name + ", value " + value + " has no type."));
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Emitting metric " + name + ", type " + type + ", value " + value + ", slope " + gSlope.name() + " from hostname " + this.getHostName()));
        }
        this.xdr_int(0);
        this.xdr_string(type);
        this.xdr_string(name);
        this.xdr_string(value);
        this.xdr_string(gConf.getUnits());
        this.xdr_int(gSlope.ordinal());
        this.xdr_int(gConf.getTmax());
        this.xdr_int(gConf.getDmax());
        this.emitToGangliaHosts();
    }
}

