/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import oadd.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.SampleStat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableStat
extends MutableMetric {
    private final MetricsInfo numInfo;
    private final MetricsInfo avgInfo;
    private final MetricsInfo stdevInfo;
    private final MetricsInfo iMinInfo;
    private final MetricsInfo iMaxInfo;
    private final MetricsInfo minInfo;
    private final MetricsInfo maxInfo;
    private final SampleStat intervalStat = new SampleStat();
    private final SampleStat prevStat = new SampleStat();
    private final SampleStat.MinMax minMax = new SampleStat.MinMax();
    private long numSamples = 0L;
    private boolean extended = false;

    public MutableStat(String name, String description, String sampleName, String valueName, boolean extended) {
        String ucName = StringUtils.capitalize(name);
        String usName = StringUtils.capitalize(sampleName);
        String uvName = StringUtils.capitalize(valueName);
        String desc = StringUtils.uncapitalize(description);
        String lsName = StringUtils.uncapitalize(sampleName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.numInfo = Interns.info(ucName + "Num" + usName, "Number of " + lsName + " for " + desc);
        this.avgInfo = Interns.info(ucName + "Avg" + uvName, "Average " + lvName + " for " + desc);
        this.stdevInfo = Interns.info(ucName + "Stdev" + uvName, "Standard deviation of " + lvName + " for " + desc);
        this.iMinInfo = Interns.info(ucName + "IMin" + uvName, "Interval min " + lvName + " for " + desc);
        this.iMaxInfo = Interns.info(ucName + "IMax" + uvName, "Interval max " + lvName + " for " + desc);
        this.minInfo = Interns.info(ucName + "Min" + uvName, "Min " + lvName + " for " + desc);
        this.maxInfo = Interns.info(ucName + "Max" + uvName, "Max " + lvName + " for " + desc);
        this.extended = extended;
    }

    public MutableStat(String name, String description, String sampleName, String valueName) {
        this(name, description, sampleName, valueName, false);
    }

    public synchronized void setExtended(boolean extended) {
        this.extended = extended;
    }

    public synchronized void add(long numSamples, long sum) {
        this.intervalStat.add(numSamples, sum);
        this.setChanged();
    }

    public synchronized void add(long value) {
        this.intervalStat.add(value);
        this.minMax.add(value);
        this.setChanged();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            this.numSamples += this.intervalStat.numSamples();
            builder.addCounter(this.numInfo, this.numSamples).addGauge(this.avgInfo, this.lastStat().mean());
            if (this.extended) {
                builder.addGauge(this.stdevInfo, this.lastStat().stddev()).addGauge(this.iMinInfo, this.lastStat().min()).addGauge(this.iMaxInfo, this.lastStat().max()).addGauge(this.minInfo, this.minMax.min()).addGauge(this.maxInfo, this.minMax.max());
            }
            if (this.changed()) {
                if (this.numSamples > 0L) {
                    this.intervalStat.copyTo(this.prevStat);
                    this.intervalStat.reset();
                }
                this.clearChanged();
            }
        }
    }

    private SampleStat lastStat() {
        return this.changed() ? this.intervalStat : this.prevStat;
    }

    public void resetMinMax() {
        this.minMax.reset();
    }
}

