/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import oadd.org.apache.log4j.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;

public class SecureHTTPURLConnectionProvider {
    private static final Logger LOG = Logger.getLogger(SecureHTTPURLConnectionProvider.class);
    private static AuthenticatedURL.Token token = new AuthenticatedURL.Token();
    private static Authenticator authenticator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLConnection openConnection(URL url) throws IOException {
        if (authenticator == null) {
            return url.openConnection();
        }
        Class<SecureHTTPURLConnectionProvider> clazz = SecureHTTPURLConnectionProvider.class;
        synchronized (SecureHTTPURLConnectionProvider.class) {
            HttpURLConnection conn = null;
            if (token.isSet()) {
                conn = (HttpURLConnection)url.openConnection();
                AuthenticatedURL.injectToken(conn, token);
                conn.connect();
                if (conn.getResponseCode() == 401) {
                    token = new AuthenticatedURL.Token();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Received HTTP " + conn.getResponseCode() + ". Created a new token."));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received HTTP " + conn.getResponseCode() + ". Token still good.."));
                }
            }
            if (!token.isSet()) {
                LOG.debug((Object)"Token not set. Peforming authentication..");
                AuthenticatedURL authenticatedURL = new AuthenticatedURL(authenticator);
                try {
                    conn = authenticatedURL.openConnection(url, token);
                }
                catch (AuthenticationException e) {
                    LOG.error((Object)("Authentication failed while connecting to URL: " + url.toString()));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return conn;
        }
    }

    static {
        Configuration conf = new Configuration();
        Class<Authenticator> clazz = conf.getClass("hadoop.log.level.authenticator.class", null, Authenticator.class);
        if (clazz != null) {
            try {
                authenticator = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

