/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRates;

@InterfaceAudience.Private
@Metrics(about="Per method RPC metrics", context="rpcdetailed")
public class RpcDetailedMetrics {
    @Metric
    MutableRates rates;
    static final Log LOG = LogFactory.getLog(RpcDetailedMetrics.class);
    final MetricsRegistry registry;
    final String name;

    RpcDetailedMetrics(int port) {
        this.name = "RpcDetailedActivityForPort" + port;
        this.registry = new MetricsRegistry("rpcdetailed").tag("port", "RPC port", String.valueOf(port));
        LOG.debug((Object)this.registry.info());
    }

    public String name() {
        return this.name;
    }

    public static RpcDetailedMetrics create(int port) {
        RpcDetailedMetrics m = new RpcDetailedMetrics(port);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    public void init(Class<?> protocol) {
        this.rates.init(protocol);
    }

    public void addProcessingTime(String name, int processingTime) {
        this.rates.add(name, processingTime);
    }

    public void shutdown() {
    }
}

