/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import oadd.com.google.protobuf.RpcController;
import oadd.com.google.protobuf.ServiceException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HAServiceProtocolClientSideTranslatorPB
implements HAServiceProtocol,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private static final HAServiceProtocolProtos.MonitorHealthRequestProto MONITOR_HEALTH_REQ = HAServiceProtocolProtos.MonitorHealthRequestProto.newBuilder().build();
    private static final HAServiceProtocolProtos.GetServiceStatusRequestProto GET_SERVICE_STATUS_REQ = HAServiceProtocolProtos.GetServiceStatusRequestProto.newBuilder().build();
    private final HAServiceProtocolPB rpcProxy;

    public HAServiceProtocolClientSideTranslatorPB(InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine(conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
        this.rpcProxy = RPC.getProxy(HAServiceProtocolPB.class, RPC.getProtocolVersion(HAServiceProtocolPB.class), addr, conf);
    }

    public HAServiceProtocolClientSideTranslatorPB(InetSocketAddress addr, Configuration conf, SocketFactory socketFactory, int timeout) throws IOException {
        RPC.setProtocolEngine(conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
        this.rpcProxy = RPC.getProxy(HAServiceProtocolPB.class, RPC.getProtocolVersion(HAServiceProtocolPB.class), addr, UserGroupInformation.getCurrentUser(), conf, socketFactory, timeout);
    }

    @Override
    public void monitorHealth() throws IOException {
        try {
            this.rpcProxy.monitorHealth(NULL_CONTROLLER, MONITOR_HEALTH_REQ);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            HAServiceProtocolProtos.TransitionToActiveRequestProto req = HAServiceProtocolProtos.TransitionToActiveRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).build();
            this.rpcProxy.transitionToActive(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            HAServiceProtocolProtos.TransitionToStandbyRequestProto req = HAServiceProtocolProtos.TransitionToStandbyRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).build();
            this.rpcProxy.transitionToStandby(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HAServiceStatus getServiceStatus() throws IOException {
        HAServiceProtocolProtos.GetServiceStatusResponseProto status;
        try {
            status = this.rpcProxy.getServiceStatus(NULL_CONTROLLER, GET_SERVICE_STATUS_REQ);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
        HAServiceStatus ret = new HAServiceStatus(this.convert(status.getState()));
        if (status.getReadyToBecomeActive()) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive(status.getNotReadyReason());
        }
        return ret;
    }

    private HAServiceProtocol.HAServiceState convert(HAServiceProtocolProtos.HAServiceStateProto state) {
        switch (state) {
            case ACTIVE: {
                return HAServiceProtocol.HAServiceState.ACTIVE;
            }
            case STANDBY: {
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
        }
        return HAServiceProtocol.HAServiceState.INITIALIZING;
    }

    private HAServiceProtocolProtos.HAStateChangeRequestInfoProto convert(HAServiceProtocol.StateChangeRequestInfo reqInfo) {
        HAServiceProtocolProtos.HARequestSource src;
        switch (reqInfo.getSource()) {
            case REQUEST_BY_USER: {
                src = HAServiceProtocolProtos.HARequestSource.REQUEST_BY_USER;
                break;
            }
            case REQUEST_BY_USER_FORCED: {
                src = HAServiceProtocolProtos.HARequestSource.REQUEST_BY_USER_FORCED;
                break;
            }
            case REQUEST_BY_ZKFC: {
                src = HAServiceProtocolProtos.HARequestSource.REQUEST_BY_ZKFC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad source: " + (Object)((Object)reqInfo.getSource()));
            }
        }
        return HAServiceProtocolProtos.HAStateChangeRequestInfoProto.newBuilder().setReqSource(src).build();
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

