/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.com.google.common.collect.Sets;
import oadd.org.reflections.Configuration;
import oadd.org.reflections.Reflections;
import oadd.org.reflections.adapters.JavassistAdapter;
import oadd.org.reflections.adapters.MetadataAdapter;
import oadd.org.reflections.scanners.Scanner;
import oadd.org.reflections.scanners.SubTypesScanner;
import oadd.org.reflections.scanners.TypeAnnotationsScanner;
import oadd.org.reflections.serializers.Serializer;
import oadd.org.reflections.serializers.XmlSerializer;
import oadd.org.reflections.util.ClasspathHelper;
import oadd.org.reflections.util.FilterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
implements Configuration {
    private final Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    private Set<URL> urls = Sets.newHashSet();
    private MetadataAdapter metadataAdapter;
    private Predicate<String> inputsFilter;
    private Serializer serializer;
    private ExecutorService executorService;
    private ClassLoader[] classLoaders;

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... params) {
        void var5_7;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ArrayList<Object> parameters = Lists.newArrayList();
        Object[] arr$ = params;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            Object param = arr$[var5_7];
            if (param != null) {
                if (param.getClass().isArray()) {
                    for (Object p : (Object[])param) {
                        if (p == null) continue;
                        parameters.add(p);
                    }
                } else if (param instanceof Iterable) {
                    for (Object p : (Iterable)param) {
                        if (p == null) continue;
                        parameters.add(p);
                    }
                } else {
                    parameters.add(param);
                }
            }
            ++var5_7;
        }
        ArrayList<ClassLoader> loaders = Lists.newArrayList();
        for (Object e : parameters) {
            if (!(e instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)e);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> scanners = Lists.newArrayList();
        for (Object param : parameters) {
            if (param instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)param, classLoaders));
                filterBuilder.include(FilterBuilder.prefix((String)param));
                continue;
            }
            if (param instanceof Class) {
                builder.addUrls(ClasspathHelper.forClass((Class)param, classLoaders));
                filterBuilder.includePackage((Class)param);
                continue;
            }
            if (param instanceof Scanner) {
                scanners.add((Scanner)param);
                continue;
            }
            if (param instanceof URL) {
                builder.addUrls((URL)param);
                continue;
            }
            if (param instanceof ClassLoader || Reflections.log == null) continue;
            Reflections.log.warn("could not use param " + param);
        }
        builder.filterInputsBy(filterBuilder);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Sets.newHashSet(urls));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        return this.metadataAdapter != null ? this.metadataAdapter : (this.metadataAdapter = new JavassistAdapter());
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public boolean acceptsInput(String inputFqn) {
        return this.inputsFilter == null || this.inputsFilter.apply(inputFqn);
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

