/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oadd.org.json.JSONException;
import oadd.org.json.JSONObject;
import oadd.org.json.JSONTokener;

public class JSONArray {
    private ArrayList myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(JSONTokener jSONTokener) throws JSONException {
        this();
        char c;
        char c2 = jSONTokener.nextClean();
        if (c2 == '[') {
            c = ']';
        } else if (c2 == '(') {
            c = ')';
        } else {
            throw jSONTokener.syntaxError("A JSONArray text must start with '['");
        }
        if (jSONTokener.nextClean() == ']') {
            return;
        }
        jSONTokener.back();
        block4: while (true) {
            if (jSONTokener.nextClean() == ',') {
                jSONTokener.back();
                this.myArrayList.add(null);
            } else {
                jSONTokener.back();
                this.myArrayList.add(jSONTokener.nextValue());
            }
            c2 = jSONTokener.nextClean();
            switch (c2) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == ']') {
                        return;
                    }
                    jSONTokener.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (c != c2) {
                        throw jSONTokener.syntaxError("Expected a '" + new Character(c) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection collection) {
        this.myArrayList = collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public JSONArray(Collection collection, boolean bl) {
        this.myArrayList = new ArrayList();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.myArrayList.add(new JSONObject(iterator.next(), bl));
            }
        }
    }

    public JSONArray(Object object) throws JSONException {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.put(Array.get(object, i));
            }
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    public JSONArray(Object object, boolean bl) throws JSONException {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.put(new JSONObject(Array.get(object, i), bl));
            }
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int n) throws JSONException {
        Object object = this.opt(n);
        if (object == null) {
            throw new JSONException("JSONArray[" + n + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int n) throws JSONException {
        Object object = this.get(n);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + n + "] is not a Boolean.");
    }

    public double getDouble(int n) throws JSONException {
        Object object = this.get(n);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf((String)object).doubleValue();
        }
        catch (Exception exception) {
            throw new JSONException("JSONArray[" + n + "] is not a number.");
        }
    }

    public int getInt(int n) throws JSONException {
        Object object = this.get(n);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(n);
    }

    public JSONArray getJSONArray(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + n + "] is not a JSONObject.");
    }

    public long getLong(int n) throws JSONException {
        Object object = this.get(n);
        return object instanceof Number ? ((Number)object).longValue() : (long)this.getDouble(n);
    }

    public String getString(int n) throws JSONException {
        return this.get(n).toString();
    }

    public boolean isNull(int n) {
        return JSONObject.NULL.equals(this.opt(n));
    }

    public String join(String string) throws JSONException {
        int n = this.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int n) {
        return n < 0 || n >= this.length() ? null : this.myArrayList.get(n);
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JSONArray optJSONArray(int n) {
        Object object = this.opt(n);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(int n) {
        Object object = this.opt(n);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string) {
        Object object = this.opt(n);
        return object != null ? object.toString() : string;
    }

    public JSONArray put(boolean bl) {
        this.put(bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection collection) {
        this.put(new JSONArray(collection));
        return this;
    }

    public JSONArray put(double d) throws JSONException {
        Double d2 = new Double(d);
        JSONObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JSONArray put(int n) {
        this.put(new Integer(n));
        return this;
    }

    public JSONArray put(long l) {
        this.put(new Long(l));
        return this;
    }

    public JSONArray put(Map map) {
        this.put(new JSONObject(map));
        return this;
    }

    public JSONArray put(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public JSONArray put(int n, boolean bl) throws JSONException {
        this.put(n, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int n, Collection collection) throws JSONException {
        this.put(n, new JSONArray(collection));
        return this;
    }

    public JSONArray put(int n, double d) throws JSONException {
        this.put(n, new Double(d));
        return this;
    }

    public JSONArray put(int n, int n2) throws JSONException {
        this.put(n, new Integer(n2));
        return this;
    }

    public JSONArray put(int n, long l) throws JSONException {
        this.put(n, new Long(l));
        return this;
    }

    public JSONArray put(int n, Map map) throws JSONException {
        this.put(n, new JSONObject(map));
        return this;
    }

    public JSONArray put(int n, Object object) throws JSONException {
        JSONObject.testValidity(object);
        if (n < 0) {
            throw new JSONException("JSONArray[" + n + "] not found.");
        }
        if (n < this.length()) {
            this.myArrayList.set(n, object);
        } else {
            while (n != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(object);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject.put(jSONArray.getString(i), this.opt(i));
        }
        return jSONObject;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) throws JSONException {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) throws JSONException {
        int n3 = this.length();
        if (n3 == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n3 == 1) {
            stringBuffer.append(JSONObject.valueToString(this.myArrayList.get(0), n, n2));
        } else {
            int n4;
            int n5 = n2 + n;
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.valueToString(this.myArrayList.get(n4), n, n5));
            }
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean bl = false;
            int n = this.length();
            writer.write(91);
            for (int i = 0; i < n; ++i) {
                Object e;
                if (bl) {
                    writer.write(44);
                }
                if ((e = this.myArrayList.get(i)) instanceof JSONObject) {
                    ((JSONObject)e).write(writer);
                } else if (e instanceof JSONArray) {
                    ((JSONArray)e).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(e));
                }
                bl = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

