/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import oadd.org.jboss.netty.buffer.ChannelBuffer;
import oadd.org.jboss.netty.buffer.CompositeChannelBuffer;
import oadd.org.jboss.netty.channel.DefaultFileRegion;
import oadd.org.jboss.netty.channel.FileRegion;
import oadd.org.jboss.netty.util.ExternalResourceReleasable;
import oadd.org.jboss.netty.util.internal.ByteBufferUtil;

final class SocketSendBufferPool
implements ExternalResourceReleasable {
    private static final SendBuffer EMPTY_BUFFER = new EmptySendBuffer();
    private static final int DEFAULT_PREALLOCATION_SIZE = 65536;
    private static final int ALIGN_SHIFT = 4;
    private static final int ALIGN_MASK = 15;
    private PreallocationRef poolHead;
    private Preallocation current = new Preallocation(65536);

    SocketSendBufferPool() {
    }

    SendBuffer acquire(Object message) {
        if (message instanceof ChannelBuffer) {
            return this.acquire((ChannelBuffer)message);
        }
        if (message instanceof FileRegion) {
            return this.acquire((FileRegion)message);
        }
        throw new IllegalArgumentException("unsupported message type: " + message.getClass());
    }

    private SendBuffer acquire(FileRegion src) {
        if (src.getCount() == 0L) {
            return EMPTY_BUFFER;
        }
        return new FileSendBuffer(src);
    }

    private SendBuffer acquire(ChannelBuffer src) {
        PooledSendBuffer dst;
        int size = src.readableBytes();
        if (size == 0) {
            return EMPTY_BUFFER;
        }
        if (src instanceof CompositeChannelBuffer && ((CompositeChannelBuffer)src).useGathering()) {
            return new GatheringSendBuffer(src.toByteBuffers());
        }
        if (src.isDirect()) {
            return new UnpooledSendBuffer(src.toByteBuffer());
        }
        if (src.readableBytes() > 65536) {
            return new UnpooledSendBuffer(src.toByteBuffer());
        }
        Preallocation current = this.current;
        ByteBuffer buffer = current.buffer;
        int remaining = buffer.remaining();
        if (size < remaining) {
            int nextPos = buffer.position() + size;
            ByteBuffer slice = buffer.duplicate();
            buffer.position(SocketSendBufferPool.align(nextPos));
            slice.limit(nextPos);
            ++current.refCnt;
            dst = new PooledSendBuffer(current, slice);
        } else if (size > remaining) {
            this.current = current = this.getPreallocation();
            buffer = current.buffer;
            ByteBuffer slice = buffer.duplicate();
            buffer.position(SocketSendBufferPool.align(size));
            slice.limit(size);
            ++current.refCnt;
            dst = new PooledSendBuffer(current, slice);
        } else {
            ++current.refCnt;
            this.current = this.getPreallocation0();
            dst = new PooledSendBuffer(current, current.buffer);
        }
        ByteBuffer dstbuf = dst.buffer;
        dstbuf.mark();
        src.getBytes(src.readerIndex(), dstbuf);
        dstbuf.reset();
        return dst;
    }

    private Preallocation getPreallocation() {
        Preallocation current = this.current;
        if (current.refCnt == 0) {
            current.buffer.clear();
            return current;
        }
        return this.getPreallocation0();
    }

    private Preallocation getPreallocation0() {
        PreallocationRef ref = this.poolHead;
        if (ref != null) {
            do {
                Preallocation p = (Preallocation)ref.get();
                ref = ref.next;
                if (p == null) continue;
                this.poolHead = ref;
                return p;
            } while (ref != null);
            this.poolHead = ref;
        }
        return new Preallocation(65536);
    }

    private static int align(int pos) {
        int q = pos >>> 4;
        int r = pos & 0xF;
        if (r != 0) {
            ++q;
        }
        return q << 4;
    }

    public void releaseExternalResources() {
        if (this.current.buffer != null) {
            ByteBufferUtil.destroy(this.current.buffer);
        }
    }

    static final class EmptySendBuffer
    implements SendBuffer {
        EmptySendBuffer() {
        }

        public boolean finished() {
            return true;
        }

        public long writtenBytes() {
            return 0L;
        }

        public long totalBytes() {
            return 0L;
        }

        public long transferTo(WritableByteChannel ch) {
            return 0L;
        }

        public long transferTo(DatagramChannel ch, SocketAddress raddr) {
            return 0L;
        }

        public void release() {
        }
    }

    final class FileSendBuffer
    implements SendBuffer {
        private final FileRegion file;
        private long writtenBytes;

        FileSendBuffer(FileRegion file) {
            this.file = file;
        }

        public boolean finished() {
            return this.writtenBytes >= this.file.getCount();
        }

        public long writtenBytes() {
            return this.writtenBytes;
        }

        public long totalBytes() {
            return this.file.getCount();
        }

        public long transferTo(WritableByteChannel ch) throws IOException {
            long localWrittenBytes = this.file.transferTo(ch, this.writtenBytes);
            this.writtenBytes += localWrittenBytes;
            return localWrittenBytes;
        }

        public long transferTo(DatagramChannel ch, SocketAddress raddr) {
            throw new UnsupportedOperationException();
        }

        public void release() {
            if (this.file instanceof DefaultFileRegion && ((DefaultFileRegion)this.file).releaseAfterTransfer()) {
                this.file.releaseExternalResources();
            }
        }
    }

    static class GatheringSendBuffer
    implements SendBuffer {
        private final ByteBuffer[] buffers;
        private final int last;
        private long written;
        private final int total;

        GatheringSendBuffer(ByteBuffer[] buffers) {
            this.buffers = buffers;
            this.last = buffers.length - 1;
            int total = 0;
            for (ByteBuffer buf : buffers) {
                total += buf.remaining();
            }
            this.total = total;
        }

        public boolean finished() {
            return !this.buffers[this.last].hasRemaining();
        }

        public long writtenBytes() {
            return this.written;
        }

        public long totalBytes() {
            return this.total;
        }

        public long transferTo(WritableByteChannel ch) throws IOException {
            if (ch instanceof GatheringByteChannel) {
                long w = ((GatheringByteChannel)ch).write(this.buffers);
                this.written += w;
                return w;
            }
            int send = 0;
            for (ByteBuffer buf : this.buffers) {
                if (!buf.hasRemaining()) continue;
                int w = ch.write(buf);
                if (w == 0) break;
                send += w;
            }
            this.written += (long)send;
            return send;
        }

        public long transferTo(DatagramChannel ch, SocketAddress raddr) throws IOException {
            int send = 0;
            for (ByteBuffer buf : this.buffers) {
                if (!buf.hasRemaining()) continue;
                int w = ch.send(buf, raddr);
                if (w == 0) break;
                send += w;
            }
            this.written += (long)send;
            return send;
        }

        public void release() {
        }
    }

    final class PooledSendBuffer
    extends UnpooledSendBuffer {
        private final Preallocation parent;

        PooledSendBuffer(Preallocation parent, ByteBuffer buffer) {
            super(buffer);
            this.parent = parent;
        }

        public void release() {
            Preallocation parent = this.parent;
            if (--parent.refCnt == 0) {
                parent.buffer.clear();
                if (parent != SocketSendBufferPool.this.current) {
                    SocketSendBufferPool.this.poolHead = new PreallocationRef(parent, SocketSendBufferPool.this.poolHead);
                }
            }
        }
    }

    static class UnpooledSendBuffer
    implements SendBuffer {
        final ByteBuffer buffer;
        final int initialPos;

        UnpooledSendBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
            this.initialPos = buffer.position();
        }

        public final boolean finished() {
            return !this.buffer.hasRemaining();
        }

        public final long writtenBytes() {
            return this.buffer.position() - this.initialPos;
        }

        public final long totalBytes() {
            return this.buffer.limit() - this.initialPos;
        }

        public final long transferTo(WritableByteChannel ch) throws IOException {
            return ch.write(this.buffer);
        }

        public final long transferTo(DatagramChannel ch, SocketAddress raddr) throws IOException {
            return ch.send(this.buffer, raddr);
        }

        public void release() {
        }
    }

    static interface SendBuffer {
        public boolean finished();

        public long writtenBytes();

        public long totalBytes();

        public long transferTo(WritableByteChannel var1) throws IOException;

        public long transferTo(DatagramChannel var1, SocketAddress var2) throws IOException;

        public void release();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PreallocationRef
    extends SoftReference<Preallocation> {
        final PreallocationRef next;

        PreallocationRef(Preallocation prealloation, PreallocationRef next) {
            super(prealloation);
            this.next = next;
        }
    }

    private static final class Preallocation {
        final ByteBuffer buffer;
        int refCnt;

        Preallocation(int capacity) {
            this.buffer = ByteBuffer.allocateDirect(capacity);
        }
    }
}

