/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.fragment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oadd.org.apache.drill.exec.exception.FragmentSetupException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.record.RawFragmentBatch;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import oadd.org.apache.drill.exec.work.fragment.FragmentExecutor;
import oadd.org.apache.drill.exec.work.fragment.FragmentManager;

public class RootFragmentManager
implements FragmentManager {
    private final IncomingBuffers buffers;
    private final FragmentExecutor runner;
    private final ExecProtos.FragmentHandle handle;
    private volatile boolean cancel = false;
    private final List<RemoteConnection> connections = new CopyOnWriteArrayList<RemoteConnection>();

    public RootFragmentManager(ExecProtos.FragmentHandle handle, IncomingBuffers buffers, FragmentExecutor runner) {
        this.handle = handle;
        this.buffers = buffers;
        this.runner = runner;
    }

    @Override
    public boolean handle(RawFragmentBatch batch) throws FragmentSetupException, IOException {
        return this.buffers.batchArrived(batch);
    }

    @Override
    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        throw new IllegalStateException("The root fragment should not be sending any messages to receiver.");
    }

    @Override
    public FragmentExecutor getRunnable() {
        return this.runner;
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.handle;
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.runner.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void unpause() {
        this.runner.unpause();
    }

    @Override
    public boolean isWaiting() {
        return !this.buffers.isDone() && !this.cancel;
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.runner.getContext();
    }

    @Override
    public void addConnection(RemoteConnection connection) {
        this.connections.add(connection);
    }

    @Override
    public void setAutoRead(boolean autoRead) {
        for (RemoteConnection c : this.connections) {
            c.setAutoRead(autoRead);
        }
    }
}

