/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.foreman;

import oadd.org.apache.drill.exec.exception.UnsupportedOperatorCollector;
import oadd.org.apache.drill.exec.work.foreman.ForemanSetupException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedDataTypeException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedFunctionException;
import oadd.org.apache.drill.exec.work.foreman.UnsupportedRelOperatorException;

public abstract class SqlUnsupportedException
extends ForemanSetupException {
    public SqlUnsupportedException(String jiraNumber, String disabledFunctionality) {
        super(disabledFunctionality + " is not supported\n" + "See Apache Drill JIRA: DRILL-" + jiraNumber);
    }

    public SqlUnsupportedException(String errorMessage) {
        super(errorMessage);
    }

    public static void errorClassNameToException(String errorClassName) throws SqlUnsupportedException {
        UnsupportedOperatorCollector collector = new UnsupportedOperatorCollector();
        for (ExceptionType ex : ExceptionType.values()) {
            if (!errorClassName.endsWith(ex.toString())) continue;
            collector.setException(ex);
            collector.convertException();
            collector.clean();
        }
    }

    public static enum ExceptionType {
        NONE("NONE"),
        RELATIONAL(UnsupportedRelOperatorException.class.getSimpleName()),
        DATA_TYPE(UnsupportedDataTypeException.class.getSimpleName()),
        FUNCTION(UnsupportedFunctionException.class.getSimpleName());

        private String exceptionType;

        private ExceptionType(String exceptionType) {
            this.exceptionType = exceptionType;
        }

        public String toString() {
            return this.exceptionType;
        }
    }
}

