/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.foreman;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ArrayListMultimap;
import oadd.com.google.common.collect.Sets;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.common.EventProcessor;
import oadd.org.apache.drill.common.concurrent.ExtendedLatch;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.logical.LogicalPlan;
import oadd.org.apache.drill.common.logical.PlanProperties;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.DistributedSemaphore;
import oadd.org.apache.drill.exec.exception.OptimizerException;
import oadd.org.apache.drill.exec.memory.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.opt.BasicOptimizer;
import oadd.org.apache.drill.exec.physical.PhysicalPlan;
import oadd.org.apache.drill.exec.physical.base.FragmentRoot;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.base.PhysicalVisitor;
import oadd.org.apache.drill.exec.physical.config.ExternalSort;
import oadd.org.apache.drill.exec.planner.fragment.Fragment;
import oadd.org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import oadd.org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import oadd.org.apache.drill.exec.planner.sql.DirectPlan;
import oadd.org.apache.drill.exec.planner.sql.DrillSqlWorker;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.control.ControlTunnel;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.ControlsInjectorFactory;
import oadd.org.apache.drill.exec.util.Pointer;
import oadd.org.apache.drill.exec.work.EndpointListener;
import oadd.org.apache.drill.exec.work.QueryWorkUnit;
import oadd.org.apache.drill.exec.work.WorkManager;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import oadd.org.apache.drill.exec.work.foreman.ForemanException;
import oadd.org.apache.drill.exec.work.foreman.ForemanSetupException;
import oadd.org.apache.drill.exec.work.foreman.LoggedQuery;
import oadd.org.apache.drill.exec.work.foreman.QueryManager;
import oadd.org.apache.drill.exec.work.fragment.FragmentExecutor;
import oadd.org.apache.drill.exec.work.fragment.FragmentManager;
import oadd.org.apache.drill.exec.work.fragment.FragmentStatusReporter;
import oadd.org.apache.drill.exec.work.fragment.RootFragmentManager;
import oadd.org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foreman
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Foreman.class);
    private static final Logger queryLogger = LoggerFactory.getLogger("query.logger");
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(Foreman.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final long RPC_WAIT_IN_MSECS_PER_FRAGMENT = 5000L;
    private final UserBitShared.QueryId queryId;
    private final String queryIdString;
    private final UserProtos.RunQuery queryRequest;
    private final QueryContext queryContext;
    private final QueryManager queryManager;
    private final WorkManager.WorkerBee bee;
    private final DrillbitContext drillbitContext;
    private final UserServer.UserClientConnection initiatingClient;
    private volatile UserBitShared.QueryResult.QueryState state;
    private boolean resume = false;
    private volatile DistributedSemaphore.DistributedLease lease;
    private final ExtendedLatch acceptExternalEvents = new ExtendedLatch();
    private final StateListener stateListener = new StateListener();
    private final ResponseSendListener responseListener = new ResponseSendListener();
    private final StateSwitch stateSwitch = new StateSwitch();
    private final ForemanResult foremanResult = new ForemanResult();
    private final ConnectionClosedListener closeListener = new ConnectionClosedListener();
    private final ChannelFuture closeFuture;
    private String queryText;

    public Foreman(WorkManager.WorkerBee bee, DrillbitContext drillbitContext, UserServer.UserClientConnection connection, UserBitShared.QueryId queryId, UserProtos.RunQuery queryRequest) {
        this.bee = bee;
        this.queryId = queryId;
        this.queryIdString = QueryIdHelper.getQueryId(queryId);
        this.queryRequest = queryRequest;
        this.drillbitContext = drillbitContext;
        this.initiatingClient = connection;
        this.closeFuture = this.initiatingClient.getChannel().closeFuture();
        this.closeFuture.addListener(this.closeListener);
        this.queryContext = new QueryContext(connection.getSession(), drillbitContext);
        this.queryManager = new QueryManager(queryId, queryRequest, drillbitContext.getPersistentStoreProvider(), this.stateListener, this);
        this.recordNewState(UserBitShared.QueryResult.QueryState.PENDING);
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public void cancel() {
        this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.CANCELLATION_REQUESTED, null);
    }

    public void resume() {
        this.resume = true;
        this.queryContext.getExecutionControls().unpauseAll();
        this.queryManager.unpauseExecutingFragments(this.drillbitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String originalName = currentThread.getName();
        currentThread.setName(this.queryIdString + ":foreman");
        this.queryManager.markStartTime();
        try {
            injector.injectChecked(this.queryContext.getExecutionControls(), "run-try-beginning", ForemanException.class);
            this.queryText = this.queryRequest.getPlan();
            switch (this.queryRequest.getType()) {
                case LOGICAL: {
                    this.parseAndRunLogicalPlan(this.queryRequest.getPlan());
                    break;
                }
                case PHYSICAL: {
                    this.parseAndRunPhysicalPlan(this.queryRequest.getPlan());
                    break;
                }
                case SQL: {
                    this.runSQL(this.queryRequest.getPlan());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            injector.injectChecked(this.queryContext.getExecutionControls(), "run-try-end", ForemanException.class);
        }
        catch (OutOfMemoryException | OutOfMemoryRuntimeException e) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, UserException.memoryError(e).build(logger));
        }
        catch (ForemanException e) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
        }
        catch (AssertionError | Exception ex) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new ForemanException("Unexpected exception during fragment initialization: " + ((Throwable)ex).getMessage(), (Throwable)ex));
        }
        catch (OutOfMemoryError e) {
            if ("Direct buffer memory".equals(e.getMessage())) {
                this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, UserException.resourceError(e).message("One or more nodes ran out of memory while executing the query.", new Object[0]).build(logger));
            } else {
                System.out.println("Node ran out of Heap memory, exiting.");
                e.printStackTrace();
                System.out.flush();
                System.exit(-1);
            }
        }
        finally {
            this.acceptExternalEvents.countDown();
            if (this.resume) {
                this.resume();
            }
            currentThread.setName(originalName);
        }
    }

    private void releaseLease() {
        while (this.lease != null) {
            try {
                this.lease.close();
                this.lease = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                logger.warn("Failure while releasing lease.", e);
                break;
            }
        }
    }

    private void parseAndRunLogicalPlan(String json) throws ExecutionSetupException {
        LogicalPlan logicalPlan;
        try {
            logicalPlan = this.drillbitContext.getPlanReader().readLogicalPlan(json);
        }
        catch (IOException e) {
            throw new ForemanException("Failure parsing logical plan.", e);
        }
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.LOGICAL) {
            throw new ForemanException("Failure running plan.  You requested a result mode of LOGICAL and submitted a logical plan.  In this case you're output mode must be PHYSICAL or EXEC.");
        }
        this.log(logicalPlan);
        PhysicalPlan physicalPlan = this.convert(logicalPlan);
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.PHYSICAL) {
            this.returnPhysical(physicalPlan);
            return;
        }
        this.log(physicalPlan);
        this.runPhysicalPlan(physicalPlan);
    }

    private void log(LogicalPlan plan) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logical {}", (Object)plan.unparse(this.queryContext.getLpPersistence()));
        }
    }

    private void log(PhysicalPlan plan) {
        if (logger.isDebugEnabled()) {
            try {
                String planText = this.queryContext.getLpPersistence().getMapper().writeValueAsString(plan);
                logger.debug("Physical {}", (Object)planText);
            }
            catch (IOException e) {
                logger.warn("Error while attempting to log physical plan.", e);
            }
        }
    }

    private void returnPhysical(PhysicalPlan plan) throws ExecutionSetupException {
        String jsonPlan = plan.unparse(this.queryContext.getLpPersistence().getMapper().writer());
        this.runPhysicalPlan(DirectPlan.createDirectPlan((QueryContext)this.queryContext, (Object)new PhysicalFromLogicalExplain(jsonPlan)));
    }

    private void parseAndRunPhysicalPlan(String json) throws ExecutionSetupException {
        try {
            PhysicalPlan plan = this.drillbitContext.getPlanReader().readPhysicalPlan(json);
            this.runPhysicalPlan(plan);
        }
        catch (IOException e) {
            throw new ForemanSetupException("Failure while parsing physical plan.", e);
        }
    }

    private void runPhysicalPlan(PhysicalPlan plan) throws ExecutionSetupException {
        Foreman.validatePlan(plan);
        this.setupSortMemoryAllocations(plan);
        this.acquireQuerySemaphore(plan);
        QueryWorkUnit work = this.getQueryWorkUnit(plan);
        List<BitControl.PlanFragment> planFragments = work.getFragments();
        BitControl.PlanFragment rootPlanFragment = work.getRootFragment();
        assert (this.queryId == rootPlanFragment.getHandle().getQueryId());
        this.drillbitContext.getWorkBus().addFragmentStatusListener(this.queryId, this.queryManager.getFragmentStatusListener());
        this.drillbitContext.getClusterCoordinator().addDrillbitStatusListener(this.queryManager.getDrillbitStatusListener());
        logger.debug("Submitting fragments to run.");
        this.setupRootFragment(rootPlanFragment, work.getRootOperator());
        this.setupNonRootFragments(planFragments);
        this.drillbitContext.getAllocator().resetFragmentLimits();
        this.moveToState(UserBitShared.QueryResult.QueryState.RUNNING, null);
        logger.debug("Fragments running.");
    }

    private static void validatePlan(PhysicalPlan plan) throws ForemanSetupException {
        if (plan.getProperties().resultMode != PlanProperties.Generator.ResultMode.EXEC) {
            throw new ForemanSetupException(String.format("Failure running plan.  You requested a result mode of %s and a physical plan can only be output as EXEC", new Object[]{plan.getProperties().resultMode}));
        }
    }

    private void setupSortMemoryAllocations(PhysicalPlan plan) {
        LinkedList<ExternalSort> sortList = new LinkedList<ExternalSort>();
        for (PhysicalOperator op : plan.getSortedOperators()) {
            if (!(op instanceof ExternalSort)) continue;
            sortList.add((ExternalSort)op);
        }
        if (sortList.size() > 0) {
            OptionManager optionManager = this.queryContext.getOptions();
            long maxWidthPerNode = optionManager.getOption((String)"planner.width.max_per_node").num_val;
            long maxAllocPerNode = Math.min(DrillConfig.getMaxDirectMemory(), this.queryContext.getConfig().getLong("drill.exec.memory.top.max"));
            maxAllocPerNode = Math.min(maxAllocPerNode, optionManager.getOption((String)"planner.memory.max_query_memory_per_node").num_val);
            long maxSortAlloc = maxAllocPerNode / ((long)sortList.size() * maxWidthPerNode);
            logger.debug("Max sort alloc: {}", (Object)maxSortAlloc);
            for (ExternalSort externalSort : sortList) {
                externalSort.setMaxAllocation(maxSortAlloc);
            }
        }
    }

    private void acquireQuerySemaphore(PhysicalPlan plan) throws ForemanSetupException {
        OptionManager optionManager = this.queryContext.getOptions();
        boolean queuingEnabled = optionManager.getOption(ExecConstants.ENABLE_QUEUE);
        if (queuingEnabled) {
            String queueName;
            long queueThreshold = optionManager.getOption(ExecConstants.QUEUE_THRESHOLD_SIZE);
            double totalCost = 0.0;
            for (PhysicalOperator ops : plan.getSortedOperators()) {
                totalCost += ops.getCost();
            }
            long queueTimeout = optionManager.getOption(ExecConstants.QUEUE_TIMEOUT);
            try {
                DistributedSemaphore distributedSemaphore;
                ClusterCoordinator clusterCoordinator = this.drillbitContext.getClusterCoordinator();
                if (totalCost > (double)queueThreshold) {
                    int largeQueue = (int)optionManager.getOption(ExecConstants.LARGE_QUEUE_SIZE);
                    distributedSemaphore = clusterCoordinator.getSemaphore("query.large", largeQueue);
                    queueName = "large";
                } else {
                    int smallQueue = (int)optionManager.getOption(ExecConstants.SMALL_QUEUE_SIZE);
                    distributedSemaphore = clusterCoordinator.getSemaphore("query.small", smallQueue);
                    queueName = "small";
                }
                this.lease = distributedSemaphore.acquire(queueTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new ForemanSetupException("Unable to acquire slot for query.", e);
            }
            if (this.lease == null) {
                throw UserException.resourceError().message("Unable to acquire queue resources for query within timeout.  Timeout for %s queue was set at %d seconds.", queueName, queueTimeout / 1000L).build(logger);
            }
        }
    }

    Exception getCurrentException() {
        return this.foremanResult.getException();
    }

    private QueryWorkUnit getQueryWorkUnit(PhysicalPlan plan) throws ExecutionSetupException {
        PhysicalOperator rootOperator = (PhysicalOperator)plan.getSortedOperators(false).iterator().next();
        Fragment rootFragment = (Fragment)rootOperator.accept((PhysicalVisitor)MakeFragmentsVisitor.INSTANCE, null);
        SimpleParallelizer parallelizer = new SimpleParallelizer(this.queryContext);
        QueryWorkUnit queryWorkUnit = parallelizer.getFragments(this.queryContext.getOptions().getOptionList(), this.queryContext.getCurrentEndpoint(), this.queryId, this.queryContext.getActiveEndpoints(), this.drillbitContext.getPlanReader(), rootFragment, this.initiatingClient.getSession(), this.queryContext.getQueryContextInfo());
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("PlanFragments for query ");
            sb.append(this.queryId);
            sb.append('\n');
            List<BitControl.PlanFragment> planFragments = queryWorkUnit.getFragments();
            int fragmentCount = planFragments.size();
            int fragmentIndex = 0;
            for (BitControl.PlanFragment planFragment : planFragments) {
                ExecProtos.FragmentHandle fragmentHandle = planFragment.getHandle();
                sb.append("PlanFragment(");
                sb.append(++fragmentIndex);
                sb.append('/');
                sb.append(fragmentCount);
                sb.append(") major_fragment_id ");
                sb.append(fragmentHandle.getMajorFragmentId());
                sb.append(" minor_fragment_id ");
                sb.append(fragmentHandle.getMinorFragmentId());
                sb.append('\n');
                CoordinationProtos.DrillbitEndpoint endpointAssignment = planFragment.getAssignment();
                sb.append("  DrillbitEndpoint address ");
                sb.append(endpointAssignment.getAddress());
                sb.append('\n');
                String jsonString = "<<malformed JSON>>";
                sb.append("  fragment_json: ");
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    Object json = objectMapper.readValue(planFragment.getFragmentJson(), Object.class);
                    jsonString = objectMapper.defaultPrettyPrintingWriter().writeValueAsString(json);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append(jsonString);
                logger.trace(sb.toString());
            }
        }
        return queryWorkUnit;
    }

    private void moveToState(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        this.stateSwitch.moveToState(newState, exception);
    }

    private void recordNewState(UserBitShared.QueryResult.QueryState newState) {
        this.state = newState;
        this.queryManager.updateEphemeralState(newState);
    }

    private void runSQL(String sql) throws ExecutionSetupException {
        DrillSqlWorker sqlWorker = new DrillSqlWorker(this.queryContext);
        Pointer textPlan = new Pointer();
        PhysicalPlan plan = sqlWorker.getPlan(sql, textPlan);
        this.queryManager.setPlanText((String)textPlan.value);
        this.runPhysicalPlan(plan);
    }

    private PhysicalPlan convert(LogicalPlan plan) throws OptimizerException {
        if (logger.isDebugEnabled()) {
            logger.debug("Converting logical plan {}.", (Object)plan.toJsonStringSafe(this.queryContext.getLpPersistence()));
        }
        return new BasicOptimizer(this.queryContext, this.initiatingClient).optimize(new BasicOptimizer.BasicOptimizationContext(this.queryContext), plan);
    }

    public UserBitShared.QueryId getQueryId() {
        return this.queryId;
    }

    private void setupRootFragment(BitControl.PlanFragment rootFragment, FragmentRoot rootOperator) throws ExecutionSetupException {
        FragmentContext rootContext = new FragmentContext(this.drillbitContext, rootFragment, this.queryContext, this.initiatingClient, this.drillbitContext.getFunctionImplementationRegistry());
        IncomingBuffers buffers = new IncomingBuffers(rootFragment, rootContext);
        rootContext.setBuffers(buffers);
        this.queryManager.addFragmentStatusTracker(rootFragment, true);
        ControlTunnel tunnel = this.drillbitContext.getController().getTunnel(this.queryContext.getCurrentEndpoint());
        FragmentExecutor rootRunner = new FragmentExecutor(rootContext, rootFragment, new FragmentStatusReporter(rootContext, tunnel), rootOperator);
        RootFragmentManager fragmentManager = new RootFragmentManager(rootFragment.getHandle(), buffers, rootRunner);
        if (buffers.isDone()) {
            this.bee.addFragmentRunner(fragmentManager.getRunnable());
        } else {
            this.drillbitContext.getWorkBus().addFragmentManager((FragmentManager)fragmentManager);
        }
    }

    private void setupNonRootFragments(Collection<BitControl.PlanFragment> fragments) throws ForemanException {
        ArrayListMultimap<CoordinationProtos.DrillbitEndpoint, BitControl.PlanFragment> leafFragmentMap = ArrayListMultimap.create();
        ArrayListMultimap<CoordinationProtos.DrillbitEndpoint, BitControl.PlanFragment> intFragmentMap = ArrayListMultimap.create();
        for (BitControl.PlanFragment planFragment : fragments) {
            logger.trace("Tracking intermediate remote node {} with data {}", (Object)planFragment.getAssignment(), (Object)planFragment.getFragmentJson());
            this.queryManager.addFragmentStatusTracker(planFragment, false);
            if (planFragment.getLeafFragment()) {
                leafFragmentMap.put(planFragment.getAssignment(), planFragment);
                continue;
            }
            intFragmentMap.put(planFragment.getAssignment(), planFragment);
        }
        int numIntFragments = intFragmentMap.keySet().size();
        ExtendedLatch endpointLatch = new ExtendedLatch(numIntFragments);
        FragmentSubmitFailures fragmentSubmitFailures = new FragmentSubmitFailures();
        for (CoordinationProtos.DrillbitEndpoint ep : intFragmentMap.keySet()) {
            this.sendRemoteFragments(ep, intFragmentMap.get(ep), endpointLatch, fragmentSubmitFailures);
        }
        long timeout = 5000L * (long)numIntFragments;
        if (numIntFragments > 0 && !endpointLatch.awaitUninterruptibly(timeout)) {
            long numberRemaining = endpointLatch.getCount();
            throw UserException.connectionError().message("Exceeded timeout (%d) while waiting send intermediate work fragments to remote nodes. Sent %d and only heard response back from %d nodes.", timeout, numIntFragments, (long)numIntFragments - numberRemaining).build(logger);
        }
        List<FragmentSubmitFailures.SubmissionException> submissionExceptions = fragmentSubmitFailures.submissionExceptions;
        if (submissionExceptions.size() > 0) {
            HashSet<CoordinationProtos.DrillbitEndpoint> endpoints = Sets.newHashSet();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (FragmentSubmitFailures.SubmissionException e : fragmentSubmitFailures.submissionExceptions) {
                CoordinationProtos.DrillbitEndpoint endpoint = e.drillbitEndpoint;
                if (!endpoints.add(endpoint)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(endpoint.getAddress());
            }
            throw UserException.connectionError(submissionExceptions.get((int)0).rpcException).message("Error setting up remote intermediate fragment execution", new Object[0]).addContext("Nodes with failures", sb.toString()).build(logger);
        }
        injector.injectChecked(this.queryContext.getExecutionControls(), "send-fragments", ForemanException.class);
        for (CoordinationProtos.DrillbitEndpoint ep : leafFragmentMap.keySet()) {
            this.sendRemoteFragments(ep, leafFragmentMap.get(ep), null, null);
        }
    }

    private void sendRemoteFragments(CoordinationProtos.DrillbitEndpoint assignment, Collection<BitControl.PlanFragment> fragments, CountDownLatch latch, FragmentSubmitFailures fragmentSubmitFailures) {
        Controller controller = this.drillbitContext.getController();
        BitControl.InitializeFragments.Builder fb = BitControl.InitializeFragments.newBuilder();
        for (BitControl.PlanFragment planFragment : fragments) {
            fb.addFragment(planFragment);
        }
        BitControl.InitializeFragments initFrags = fb.build();
        logger.debug("Sending remote fragments to \nNode:\n{} \n\nData:\n{}", (Object)assignment, (Object)initFrags);
        FragmentSubmitListener listener = new FragmentSubmitListener(assignment, initFrags, latch, fragmentSubmitFailures);
        controller.getTunnel(assignment).sendFragments((RpcOutcomeListener)listener, initFrags);
    }

    public UserBitShared.QueryResult.QueryState getState() {
        return this.state;
    }

    private class ResponseSendListener
    extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
        private ResponseSendListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.info("Failure while trying communicate query result to initiating client. This would happen if a client is disconnected before response notice can be sent.", ex);
            Foreman.this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, ex);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while waiting for RPC outcome of sending final query result to initiating client.");
            Foreman.this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
        }
    }

    public class StateListener {
        public void moveToState(UserBitShared.QueryResult.QueryState newState, Exception ex) {
            Foreman.this.acceptExternalEvents.awaitUninterruptibly();
            Foreman.this.moveToState(newState, ex);
        }
    }

    private class FragmentSubmitListener
    extends EndpointListener<GeneralRPCProtos.Ack, BitControl.InitializeFragments> {
        private final CountDownLatch latch;
        private final FragmentSubmitFailures fragmentSubmitFailures;

        public FragmentSubmitListener(CoordinationProtos.DrillbitEndpoint endpoint, BitControl.InitializeFragments value, CountDownLatch latch, FragmentSubmitFailures fragmentSubmitFailures) {
            super(endpoint, value);
            Preconditions.checkState(latch == null == (fragmentSubmitFailures == null));
            this.latch = latch;
            this.fragmentSubmitFailures = fragmentSubmitFailures;
        }

        @Override
        public void success(GeneralRPCProtos.Ack ack, ByteBuf byteBuf) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        @Override
        public void failed(RpcException ex) {
            if (this.latch != null) {
                this.fragmentSubmitFailures.addFailure(this.endpoint, ex);
                this.latch.countDown();
            } else {
                logger.debug("Failure while sending fragment.  Stopping query.", ex);
                Foreman.this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, ex);
            }
        }

        @Override
        public void interrupted(InterruptedException e) {
            String errMsg = "Interrupted while waiting for the RPC outcome of fragment submission.";
            logger.error("Interrupted while waiting for the RPC outcome of fragment submission.", e);
            this.failed(new RpcException("Interrupted while waiting for the RPC outcome of fragment submission.", e));
        }
    }

    private static class FragmentSubmitFailures {
        final List<SubmissionException> submissionExceptions = new LinkedList<SubmissionException>();

        private FragmentSubmitFailures() {
        }

        void addFailure(CoordinationProtos.DrillbitEndpoint drillbitEndpoint, RpcException rpcException) {
            this.submissionExceptions.add(new SubmissionException(drillbitEndpoint, rpcException));
        }

        static class SubmissionException {
            final CoordinationProtos.DrillbitEndpoint drillbitEndpoint;
            final RpcException rpcException;

            SubmissionException(CoordinationProtos.DrillbitEndpoint drillbitEndpoint, RpcException rpcException) {
                this.drillbitEndpoint = drillbitEndpoint;
                this.rpcException = rpcException;
            }
        }
    }

    private class StateSwitch
    extends EventProcessor<StateEvent> {
        private StateSwitch() {
        }

        public void moveToState(UserBitShared.QueryResult.QueryState newState, Exception exception) {
            this.sendEvent(new StateEvent(newState, exception));
        }

        @Override
        protected void processEvent(StateEvent event) {
            UserBitShared.QueryResult.QueryState newState = event.newState;
            Exception exception = event.exception;
            logger.debug(Foreman.this.queryIdString + ": State change requested {} --> {}", Foreman.this.state, newState, exception);
            switch (Foreman.this.state) {
                case PENDING: {
                    if (newState == UserBitShared.QueryResult.QueryState.RUNNING) {
                        Foreman.this.recordNewState(UserBitShared.QueryResult.QueryState.RUNNING);
                        return;
                    }
                }
                case RUNNING: {
                    switch (newState) {
                        case CANCELLATION_REQUESTED: {
                            assert (exception == null);
                            Foreman.this.recordNewState(UserBitShared.QueryResult.QueryState.CANCELLATION_REQUESTED);
                            Foreman.this.queryManager.cancelExecutingFragments(Foreman.this.drillbitContext);
                            Foreman.this.foremanResult.setCompleted(UserBitShared.QueryResult.QueryState.CANCELED);
                            return;
                        }
                        case COMPLETED: {
                            assert (exception == null);
                            Foreman.this.recordNewState(UserBitShared.QueryResult.QueryState.COMPLETED);
                            Foreman.this.foremanResult.setCompleted(UserBitShared.QueryResult.QueryState.COMPLETED);
                            Foreman.this.foremanResult.close();
                            return;
                        }
                        case FAILED: {
                            assert (exception != null);
                            Foreman.this.recordNewState(UserBitShared.QueryResult.QueryState.FAILED);
                            Foreman.this.queryManager.cancelExecutingFragments(Foreman.this.drillbitContext);
                            Foreman.this.foremanResult.setFailed(exception);
                            Foreman.this.foremanResult.close();
                            return;
                        }
                    }
                    throw new IllegalStateException("illegal transition from RUNNING to " + newState);
                }
                case CANCELLATION_REQUESTED: {
                    if (newState == UserBitShared.QueryResult.QueryState.CANCELED || newState == UserBitShared.QueryResult.QueryState.COMPLETED || newState == UserBitShared.QueryResult.QueryState.FAILED) {
                        if (Foreman.this.drillbitContext.getConfig().getBoolean("drill.exec.debug.return_error_for_failure_in_cancelled_fragments") && newState == UserBitShared.QueryResult.QueryState.FAILED) {
                            assert (exception != null);
                            Foreman.this.recordNewState(UserBitShared.QueryResult.QueryState.FAILED);
                            Foreman.this.foremanResult.setForceFailure(exception);
                        }
                        Foreman.this.foremanResult.close();
                    }
                    return;
                }
                case COMPLETED: 
                case FAILED: 
                case CANCELED: {
                    logger.warn("Dropping request to move to {} state as query is already at {} state (which is terminal).", (Object)newState, (Object)Foreman.this.state);
                    return;
                }
            }
            throw new IllegalStateException(String.format("Failure trying to change states: %s --> %s", Foreman.this.state.name(), newState.name()));
        }
    }

    private static class StateEvent {
        final UserBitShared.QueryResult.QueryState newState;
        final Exception exception;

        StateEvent(UserBitShared.QueryResult.QueryState newState, Exception exception) {
            this.newState = newState;
            this.exception = exception;
        }
    }

    private class ForemanResult
    implements AutoCloseable {
        private UserBitShared.QueryResult.QueryState resultState = null;
        private volatile Exception resultException = null;
        private boolean isClosed = false;

        private ForemanResult() {
        }

        public void setCompleted(UserBitShared.QueryResult.QueryState queryState) {
            Preconditions.checkArgument(queryState == UserBitShared.QueryResult.QueryState.COMPLETED || queryState == UserBitShared.QueryResult.QueryState.CANCELED);
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState == null);
            this.resultState = queryState;
        }

        public void setFailed(Exception exception) {
            Preconditions.checkArgument(exception != null);
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState == null);
            this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
            this.resultException = exception;
        }

        public void setForceFailure(Exception exception) {
            Preconditions.checkArgument(exception != null);
            Preconditions.checkState(!this.isClosed);
            this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
            this.resultException = exception;
        }

        private void addException(Exception exception) {
            Preconditions.checkNotNull(exception);
            if (this.resultException == null) {
                this.resultException = exception;
            } else {
                this.resultException.addSuppressed(exception);
            }
        }

        public Exception getException() {
            return this.resultException;
        }

        private void suppressingClose(AutoCloseable autoCloseable) {
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState != null);
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
                this.addException(e);
            }
        }

        private void logQuerySummary() {
            try {
                LoggedQuery q = new LoggedQuery(Foreman.this.queryIdString, Foreman.this.queryContext.getQueryContextInfo().getDefaultSchemaName(), Foreman.this.queryText, new Date(Foreman.this.queryContext.getQueryContextInfo().getQueryStartTime()), new Date(System.currentTimeMillis()), Foreman.this.state, Foreman.this.queryContext.getSession().getCredentials().getUserName());
                queryLogger.info(MAPPER.writeValueAsString(q));
            }
            catch (Exception e) {
                logger.error("Failure while recording query information to query log.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            UserException uex;
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState != null);
            Foreman.this.queryManager.markEndTime();
            logger.debug(Foreman.this.queryIdString + ": cleaning up.");
            injector.injectPause(Foreman.this.queryContext.getExecutionControls(), "foreman-cleanup", logger);
            Foreman.this.closeFuture.removeListener(Foreman.this.closeListener);
            this.logQuerySummary();
            Foreman.this.drillbitContext.getWorkBus().removeFragmentStatusListener(Foreman.this.queryId);
            Foreman.this.drillbitContext.getClusterCoordinator().removeDrillbitStatusListener(Foreman.this.queryManager.getDrillbitStatusListener());
            this.suppressingClose(Foreman.this.queryContext);
            if (this.resultState != Foreman.this.state) {
                this.suppressingClose(new AutoCloseable(){

                    @Override
                    public void close() throws Exception {
                        Foreman.this.recordNewState(ForemanResult.this.resultState);
                    }
                });
            }
            UserBitShared.QueryResult.Builder resultBuilder = UserBitShared.QueryResult.newBuilder().setQueryId(Foreman.this.queryId).setQueryState(this.resultState);
            if (this.resultException != null) {
                boolean verbose = ((Foreman)Foreman.this).queryContext.getOptions().getOption((String)"exec.errors.verbose").bool_val;
                uex = UserException.systemError(this.resultException).addIdentity(Foreman.this.queryContext.getCurrentEndpoint()).build(logger);
                resultBuilder.addError(uex.getOrCreatePBError(verbose));
            } else {
                uex = null;
            }
            Foreman.this.queryManager.writeFinalProfile(uex);
            try {
                Foreman.this.initiatingClient.sendResult(Foreman.this.responseListener, resultBuilder.build(), true);
            }
            catch (Exception e) {
                this.addException(e);
                logger.warn("Exception sending result to client", this.resultException);
            }
            Foreman.this.bee.retireForeman(Foreman.this);
            try {
                Foreman.this.releaseLease();
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public static class PhysicalFromLogicalExplain {
        public final String json;

        public PhysicalFromLogicalExplain(String json) {
            this.json = json;
        }
    }

    private class ConnectionClosedListener
    implements GenericFutureListener<Future<Void>> {
        private ConnectionClosedListener() {
        }

        @Override
        public void operationComplete(Future<Void> future) throws Exception {
            Foreman.this.cancel();
        }
    }
}

