/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.collect.ImmutableMap;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.exec.exception.FragmentSetupException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.record.RawFragmentBatch;
import oadd.org.apache.drill.exec.work.batch.AbstractDataCollector;
import oadd.org.apache.drill.exec.work.batch.DataCollector;
import oadd.org.apache.drill.exec.work.batch.MergingCollector;
import oadd.org.apache.drill.exec.work.batch.PartitionedCollector;
import oadd.org.apache.drill.exec.work.batch.RawBatchBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingBuffers
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(IncomingBuffers.class);
    private final AtomicInteger streamsRemaining = new AtomicInteger(0);
    private final AtomicInteger remainingRequired;
    private final Map<Integer, DataCollector> fragCounts;
    private final FragmentContext context;

    public IncomingBuffers(BitControl.PlanFragment fragment, FragmentContext context) {
        this.context = context;
        HashMap<Integer, MergingCollector> collectors = Maps.newHashMap();
        this.remainingRequired = new AtomicInteger(fragment.getCollectorCount());
        for (int i = 0; i < fragment.getCollectorCount(); ++i) {
            BitControl.Collector collector = fragment.getCollector(i);
            AbstractDataCollector newCollector = collector.getSupportsOutOfOrder() ? new MergingCollector(this.remainingRequired, collector, context) : new PartitionedCollector(this.remainingRequired, collector, context);
            collectors.put(collector.getOppositeMajorFragmentId(), (MergingCollector)newCollector);
        }
        logger.debug("Came up with a list of {} required fragments.  Fragments {}", (Object)this.remainingRequired.get(), (Object)collectors);
        this.fragCounts = ImmutableMap.copyOf(collectors);
        int totalStreams = 0;
        for (DataCollector bc : this.fragCounts.values()) {
            totalStreams += bc.getTotalIncomingFragments();
        }
        assert (totalStreams >= this.remainingRequired.get()) : String.format("Total Streams %d should be more than the minimum number of streams to commence (%d).  It isn't.", totalStreams, this.remainingRequired.get());
        this.streamsRemaining.set(totalStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchArrived(RawFragmentBatch batch) throws FragmentSetupException, IOException {
        int sendMajorFragmentId;
        DataCollector fSet;
        if (batch.getHeader().getIsOutOfMemory()) {
            for (DataCollector fSet2 : this.fragCounts.values()) {
                fSet2.batchArrived(0, batch);
            }
            return false;
        }
        if (batch.getHeader().getIsLastBatch()) {
            this.streamsRemaining.decrementAndGet();
        }
        if ((fSet = this.fragCounts.get(sendMajorFragmentId = batch.getHeader().getSendingMajorFragmentId())) == null) {
            throw new FragmentSetupException(String.format("We received a major fragment id that we were not expecting.  The id was %d. %s", sendMajorFragmentId, Arrays.toString(this.fragCounts.values().toArray())));
        }
        IncomingBuffers incomingBuffers = this;
        synchronized (incomingBuffers) {
            boolean decremented = fSet.batchArrived(batch.getHeader().getSendingMinorFragmentId(), batch);
            return decremented && this.remainingRequired.get() == 0;
        }
    }

    public int getRemainingRequired() {
        int rem = this.remainingRequired.get();
        if (rem < 0) {
            return 0;
        }
        return rem;
    }

    public RawBatchBuffer[] getBuffers(int senderMajorFragmentId) {
        return this.fragCounts.get(senderMajorFragmentId).getBuffers();
    }

    public boolean isDone() {
        return this.streamsRemaining.get() < 1;
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.fragCounts.values().toArray(new AutoCloseable[0]));
    }
}

